/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.UserReference;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class BulkUpdateShiftTradeStateResultItem
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private UserReference reviewedBy = null;
    private Date reviewedDate = null;
    private FailureReasonEnum failureReason = null;
    private WfmVersionedEntityMetadata metadata = null;

    public BulkUpdateShiftTradeStateResultItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BulkUpdateShiftTradeStateResultItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the shift trade after the update request is processed")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public BulkUpdateShiftTradeStateResultItem reviewedBy(UserReference reviewedBy) {
        this.reviewedBy = reviewedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who reviewed the request, if applicable. The id may be 'System' if it was an automated process")
    @JsonProperty(value="reviewedBy")
    public UserReference getReviewedBy() {
        return this.reviewedBy;
    }

    public void setReviewedBy(UserReference reviewedBy) {
        this.reviewedBy = reviewedBy;
    }

    public BulkUpdateShiftTradeStateResultItem reviewedDate(Date reviewedDate) {
        this.reviewedDate = reviewedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the request was reviewed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="reviewedDate")
    public Date getReviewedDate() {
        return this.reviewedDate;
    }

    public void setReviewedDate(Date reviewedDate) {
        this.reviewedDate = reviewedDate;
    }

    public BulkUpdateShiftTradeStateResultItem failureReason(FailureReasonEnum failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason the update failed, if applicable")
    @JsonProperty(value="failureReason")
    public FailureReasonEnum getFailureReason() {
        return this.failureReason;
    }

    public void setFailureReason(FailureReasonEnum failureReason) {
        this.failureReason = failureReason;
    }

    public BulkUpdateShiftTradeStateResultItem metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Version metadata for the shift trade")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkUpdateShiftTradeStateResultItem bulkUpdateShiftTradeStateResultItem = (BulkUpdateShiftTradeStateResultItem)o;
        return Objects.equals(this.id, bulkUpdateShiftTradeStateResultItem.id) && Objects.equals((Object)this.state, (Object)bulkUpdateShiftTradeStateResultItem.state) && Objects.equals(this.reviewedBy, bulkUpdateShiftTradeStateResultItem.reviewedBy) && Objects.equals(this.reviewedDate, bulkUpdateShiftTradeStateResultItem.reviewedDate) && Objects.equals((Object)this.failureReason, (Object)bulkUpdateShiftTradeStateResultItem.failureReason) && Objects.equals(this.metadata, bulkUpdateShiftTradeStateResultItem.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.reviewedBy, this.reviewedDate, this.failureReason, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkUpdateShiftTradeStateResultItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    reviewedBy: ").append(this.toIndentedString(this.reviewedBy)).append("\n");
        sb.append("    reviewedDate: ").append(this.toIndentedString(this.reviewedDate)).append("\n");
        sb.append("    failureReason: ").append(this.toIndentedString((Object)this.failureReason)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        UNMATCHED("Unmatched"),
        MATCHED("Matched"),
        APPROVED("Approved"),
        DENIED("Denied"),
        EXPIRED("Expired"),
        CANCELED("Canceled");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=FailureReasonEnumDeserializer.class)
    public static enum FailureReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INITIATINGAGENTSCHEDULENOTFOUND("InitiatingAgentScheduleNotFound"),
        INITIATINGAGENTSHIFTHASEXTERNALACTIVITIES("InitiatingAgentShiftHasExternalActivities"),
        INITIATINGAGENTSHIFTNOTFOUND("InitiatingAgentShiftNotFound"),
        INITIATINGEXTERNALACTIVITYOUTSIDERECEIVINGSHIFT("InitiatingExternalActivityOutsideReceivingShift"),
        RECEIVINGAGENTNOTFOUND("ReceivingAgentNotFound"),
        RECEIVINGAGENTSCHEDULENOTFOUND("ReceivingAgentScheduleNotFound"),
        RECEIVINGAGENTSHIFTHASEXTERNALACTIVITIES("ReceivingAgentShiftHasExternalActivities"),
        RECEIVINGAGENTSHIFTNOTFOUND("ReceivingAgentShiftNotFound"),
        RECEIVINGEXTERNALACTIVITYOUTSIDEINITIATINGSHIFT("ReceivingExternalActivityOutsideInitiatingShift"),
        SCHEDULENOTPUBLISHED("ScheduleNotPublished"),
        TRANSITIONNOTALLOWED("TransitionNotAllowed");

        private String value;

        private FailureReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FailureReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FailureReasonEnum value : FailureReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FailureReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FailureReasonEnumDeserializer
    extends StdDeserializer<FailureReasonEnum> {
        public FailureReasonEnumDeserializer() {
            super(FailureReasonEnumDeserializer.class);
        }

        public FailureReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FailureReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

