/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetRoutingEmailOutboundDomainRequest {
    private String domainId;
    private String expand;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public GetRoutingEmailOutboundDomainRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public String getExpand() {
        return this.expand;
    }

    public void setExpand(String expand) {
        this.expand = expand;
    }

    public GetRoutingEmailOutboundDomainRequest withExpand(String expand) {
        this.setExpand(expand);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetRoutingEmailOutboundDomainRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.domainId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainId' when building request for GetRoutingEmailOutboundDomainRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/routing/email/outbound/domains/{domainId}").withPathParameter("domainId", this.domainId).withQueryParameters("expand", "", this.expand).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainId) {
        return new Builder().withRequiredParams(domainId);
    }

    public static class Builder {
        private final GetRoutingEmailOutboundDomainRequest request = new GetRoutingEmailOutboundDomainRequest();

        private Builder() {
        }

        public Builder withDomainId(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public Builder withExpand(String expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpand(expandValues expand) {
            this.request.setExpand(expand.toString());
            return this;
        }

        public Builder withRequiredParams(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public GetRoutingEmailOutboundDomainRequest build() {
            if (this.request.domainId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainId' when building request for GetRoutingEmailOutboundDomainRequest.");
            }
            return this.request;
        }
    }

    public static enum expandValues {
        SETTINGS("settings");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

