/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetBillingContractBillingperiodRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingContractRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingContractsInvoiceDocumentRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingContractsInvoiceLinesRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingContractsInvoicesRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingContractsRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingReportsBillableusageRequest;
import com.mypurecloud.sdk.v2.api.request.GetBillingTrusteebillingoverviewTrustorOrgIdRequest;
import com.mypurecloud.sdk.v2.model.BillingContract;
import com.mypurecloud.sdk.v2.model.BillingContractListing;
import com.mypurecloud.sdk.v2.model.BillingContractPeriodDetail;
import com.mypurecloud.sdk.v2.model.BillingInvoiceItemListing;
import com.mypurecloud.sdk.v2.model.BillingInvoiceListing;
import com.mypurecloud.sdk.v2.model.BillingUsageReport;
import com.mypurecloud.sdk.v2.model.TrusteeBillingOverview;
import com.mypurecloud.sdk.v2.model.UrlResponse;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Date;

public class BillingApi {
    private final ApiClient pcapiClient;

    public BillingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillingApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public BillingContract getBillingContract(String contractId) throws IOException, ApiException {
        return this.getBillingContract(this.createGetBillingContractRequest(contractId));
    }

    public ApiResponse<BillingContract> getBillingContractWithHttpInfo(String contractId) throws IOException {
        return this.getBillingContract(this.createGetBillingContractRequest(contractId).withHttpInfo());
    }

    private GetBillingContractRequest createGetBillingContractRequest(String contractId) {
        return GetBillingContractRequest.builder().withContractId(contractId).build();
    }

    public BillingContract getBillingContract(GetBillingContractRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BillingContract> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BillingContract>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BillingContract> getBillingContract(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BillingContract>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BillingContractPeriodDetail getBillingContractBillingperiod(String contractId, String billingPeriodId) throws IOException, ApiException {
        return this.getBillingContractBillingperiod(this.createGetBillingContractBillingperiodRequest(contractId, billingPeriodId));
    }

    public ApiResponse<BillingContractPeriodDetail> getBillingContractBillingperiodWithHttpInfo(String contractId, String billingPeriodId) throws IOException {
        return this.getBillingContractBillingperiod(this.createGetBillingContractBillingperiodRequest(contractId, billingPeriodId).withHttpInfo());
    }

    private GetBillingContractBillingperiodRequest createGetBillingContractBillingperiodRequest(String contractId, String billingPeriodId) {
        return GetBillingContractBillingperiodRequest.builder().withContractId(contractId).withBillingPeriodId(billingPeriodId).build();
    }

    public BillingContractPeriodDetail getBillingContractBillingperiod(GetBillingContractBillingperiodRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BillingContractPeriodDetail> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BillingContractPeriodDetail>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BillingContractPeriodDetail> getBillingContractBillingperiod(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BillingContractPeriodDetail>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BillingContractListing getBillingContracts(String before, String after, String pageSize, LocalDate dateStart, LocalDate dateEnd, String status, String externalNumber) throws IOException, ApiException {
        return this.getBillingContracts(this.createGetBillingContractsRequest(before, after, pageSize, dateStart, dateEnd, status, externalNumber));
    }

    public ApiResponse<BillingContractListing> getBillingContractsWithHttpInfo(String before, String after, String pageSize, LocalDate dateStart, LocalDate dateEnd, String status, String externalNumber) throws IOException {
        return this.getBillingContracts(this.createGetBillingContractsRequest(before, after, pageSize, dateStart, dateEnd, status, externalNumber).withHttpInfo());
    }

    private GetBillingContractsRequest createGetBillingContractsRequest(String before, String after, String pageSize, LocalDate dateStart, LocalDate dateEnd, String status, String externalNumber) {
        return GetBillingContractsRequest.builder().withBefore(before).withAfter(after).withPageSize(pageSize).withDateStart(dateStart).withDateEnd(dateEnd).withStatus(status).withExternalNumber(externalNumber).build();
    }

    public BillingContractListing getBillingContracts(GetBillingContractsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BillingContractListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BillingContractListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BillingContractListing> getBillingContracts(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BillingContractListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UrlResponse getBillingContractsInvoiceDocument(String invoiceId) throws IOException, ApiException {
        return this.getBillingContractsInvoiceDocument(this.createGetBillingContractsInvoiceDocumentRequest(invoiceId));
    }

    public ApiResponse<UrlResponse> getBillingContractsInvoiceDocumentWithHttpInfo(String invoiceId) throws IOException {
        return this.getBillingContractsInvoiceDocument(this.createGetBillingContractsInvoiceDocumentRequest(invoiceId).withHttpInfo());
    }

    private GetBillingContractsInvoiceDocumentRequest createGetBillingContractsInvoiceDocumentRequest(String invoiceId) {
        return GetBillingContractsInvoiceDocumentRequest.builder().withInvoiceId(invoiceId).build();
    }

    public UrlResponse getBillingContractsInvoiceDocument(GetBillingContractsInvoiceDocumentRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UrlResponse> getBillingContractsInvoiceDocument(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BillingInvoiceItemListing getBillingContractsInvoiceLines(String invoiceId, String before, String after, String pageSize) throws IOException, ApiException {
        return this.getBillingContractsInvoiceLines(this.createGetBillingContractsInvoiceLinesRequest(invoiceId, before, after, pageSize));
    }

    public ApiResponse<BillingInvoiceItemListing> getBillingContractsInvoiceLinesWithHttpInfo(String invoiceId, String before, String after, String pageSize) throws IOException {
        return this.getBillingContractsInvoiceLines(this.createGetBillingContractsInvoiceLinesRequest(invoiceId, before, after, pageSize).withHttpInfo());
    }

    private GetBillingContractsInvoiceLinesRequest createGetBillingContractsInvoiceLinesRequest(String invoiceId, String before, String after, String pageSize) {
        return GetBillingContractsInvoiceLinesRequest.builder().withInvoiceId(invoiceId).withBefore(before).withAfter(after).withPageSize(pageSize).build();
    }

    public BillingInvoiceItemListing getBillingContractsInvoiceLines(GetBillingContractsInvoiceLinesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BillingInvoiceItemListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BillingInvoiceItemListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BillingInvoiceItemListing> getBillingContractsInvoiceLines(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BillingInvoiceItemListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BillingInvoiceListing getBillingContractsInvoices(String before, String after, String pageSize, LocalDate dateStart, LocalDate dateEnd, String paymentStatus) throws IOException, ApiException {
        return this.getBillingContractsInvoices(this.createGetBillingContractsInvoicesRequest(before, after, pageSize, dateStart, dateEnd, paymentStatus));
    }

    public ApiResponse<BillingInvoiceListing> getBillingContractsInvoicesWithHttpInfo(String before, String after, String pageSize, LocalDate dateStart, LocalDate dateEnd, String paymentStatus) throws IOException {
        return this.getBillingContractsInvoices(this.createGetBillingContractsInvoicesRequest(before, after, pageSize, dateStart, dateEnd, paymentStatus).withHttpInfo());
    }

    private GetBillingContractsInvoicesRequest createGetBillingContractsInvoicesRequest(String before, String after, String pageSize, LocalDate dateStart, LocalDate dateEnd, String paymentStatus) {
        return GetBillingContractsInvoicesRequest.builder().withBefore(before).withAfter(after).withPageSize(pageSize).withDateStart(dateStart).withDateEnd(dateEnd).withPaymentStatus(paymentStatus).build();
    }

    public BillingInvoiceListing getBillingContractsInvoices(GetBillingContractsInvoicesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BillingInvoiceListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BillingInvoiceListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BillingInvoiceListing> getBillingContractsInvoices(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BillingInvoiceListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BillingUsageReport getBillingReportsBillableusage(Date startDate, Date endDate) throws IOException, ApiException {
        return this.getBillingReportsBillableusage(this.createGetBillingReportsBillableusageRequest(startDate, endDate));
    }

    public ApiResponse<BillingUsageReport> getBillingReportsBillableusageWithHttpInfo(Date startDate, Date endDate) throws IOException {
        return this.getBillingReportsBillableusage(this.createGetBillingReportsBillableusageRequest(startDate, endDate).withHttpInfo());
    }

    private GetBillingReportsBillableusageRequest createGetBillingReportsBillableusageRequest(Date startDate, Date endDate) {
        return GetBillingReportsBillableusageRequest.builder().withStartDate(startDate).withEndDate(endDate).build();
    }

    public BillingUsageReport getBillingReportsBillableusage(GetBillingReportsBillableusageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BillingUsageReport> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BillingUsageReport>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BillingUsageReport> getBillingReportsBillableusage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BillingUsageReport>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public TrusteeBillingOverview getBillingTrusteebillingoverviewTrustorOrgId(String trustorOrgId, Integer billingPeriodIndex) throws IOException, ApiException {
        return this.getBillingTrusteebillingoverviewTrustorOrgId(this.createGetBillingTrusteebillingoverviewTrustorOrgIdRequest(trustorOrgId, billingPeriodIndex));
    }

    public ApiResponse<TrusteeBillingOverview> getBillingTrusteebillingoverviewTrustorOrgIdWithHttpInfo(String trustorOrgId, Integer billingPeriodIndex) throws IOException {
        return this.getBillingTrusteebillingoverviewTrustorOrgId(this.createGetBillingTrusteebillingoverviewTrustorOrgIdRequest(trustorOrgId, billingPeriodIndex).withHttpInfo());
    }

    private GetBillingTrusteebillingoverviewTrustorOrgIdRequest createGetBillingTrusteebillingoverviewTrustorOrgIdRequest(String trustorOrgId, Integer billingPeriodIndex) {
        return GetBillingTrusteebillingoverviewTrustorOrgIdRequest.builder().withTrustorOrgId(trustorOrgId).withBillingPeriodIndex(billingPeriodIndex).build();
    }

    public TrusteeBillingOverview getBillingTrusteebillingoverviewTrustorOrgId(GetBillingTrusteebillingoverviewTrustorOrgIdRequest request) throws IOException, ApiException {
        try {
            ApiResponse<TrusteeBillingOverview> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<TrusteeBillingOverview>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<TrusteeBillingOverview> getBillingTrusteebillingoverviewTrustorOrgId(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<TrusteeBillingOverview>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

