/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUserQueuesRequest {
    private String userId;
    private Integer pageSize;
    private Integer pageNumber;
    private Boolean joined;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetUserQueuesRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public GetUserQueuesRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public GetUserQueuesRequest withPageNumber(Integer pageNumber) {
        this.setPageNumber(pageNumber);
        return this;
    }

    public Boolean getJoined() {
        return this.joined;
    }

    public void setJoined(Boolean joined) {
        this.joined = joined;
    }

    public GetUserQueuesRequest withJoined(Boolean joined) {
        this.setJoined(joined);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserQueuesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserQueuesRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{userId}/queues").withPathParameter("userId", this.userId).withQueryParameters("pageSize", "", this.pageSize).withQueryParameters("pageNumber", "", this.pageNumber).withQueryParameters("joined", "", this.joined).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId) {
        return new Builder().withRequiredParams(userId);
    }

    public static class Builder {
        private final GetUserQueuesRequest request = new GetUserQueuesRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withPageSize(Integer pageSize) {
            this.request.setPageSize(pageSize);
            return this;
        }

        public Builder withPageNumber(Integer pageNumber) {
            this.request.setPageNumber(pageNumber);
            return this;
        }

        public Builder withJoined(Boolean joined) {
            this.request.setJoined(joined);
            return this;
        }

        public Builder withRequiredParams(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public GetUserQueuesRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserQueuesRequest.");
            }
            return this.request;
        }
    }
}

