/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetStationRequest {
    private String stationId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getStationId() {
        return this.stationId;
    }

    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    public GetStationRequest withStationId(String stationId) {
        this.setStationId(stationId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetStationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.stationId == null) {
            throw new IllegalStateException("Missing the required parameter 'stationId' when building request for GetStationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/stations/{stationId}").withPathParameter("stationId", this.stationId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String stationId) {
        return new Builder().withRequiredParams(stationId);
    }

    public static class Builder {
        private final GetStationRequest request = new GetStationRequest();

        private Builder() {
        }

        public Builder withStationId(String stationId) {
            this.request.setStationId(stationId);
            return this;
        }

        public Builder withRequiredParams(String stationId) {
            this.request.setStationId(stationId);
            return this;
        }

        public GetStationRequest build() {
            if (this.request.stationId == null) {
                throw new IllegalStateException("Missing the required parameter 'stationId' when building request for GetStationRequest.");
            }
            return this.request;
        }
    }
}

