/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ShiftTradeMatchReviewUserResponse;
import com.mypurecloud.sdk.v2.model.ShiftTradeMatchViolation;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ShiftTradeMatchReviewResponse
implements Serializable {
    private ShiftTradeMatchReviewUserResponse initiatingUser = null;
    private ShiftTradeMatchReviewUserResponse receivingUser = null;
    private List<ShiftTradeMatchViolation> violations = null;
    private List<ShiftTradeMatchViolation> adminReviewViolations = null;
    private List<UnevaluatedRulesEnum> unevaluatedRules = null;

    public ShiftTradeMatchReviewResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.violations = new ArrayList<ShiftTradeMatchViolation>();
            this.adminReviewViolations = new ArrayList<ShiftTradeMatchViolation>();
            this.unevaluatedRules = new ArrayList<UnevaluatedRulesEnum>();
        }
    }

    public ShiftTradeMatchReviewResponse initiatingUser(ShiftTradeMatchReviewUserResponse initiatingUser) {
        this.initiatingUser = initiatingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Details for the initiatingUser side of the shift trade")
    @JsonProperty(value="initiatingUser")
    public ShiftTradeMatchReviewUserResponse getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(ShiftTradeMatchReviewUserResponse initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public ShiftTradeMatchReviewResponse receivingUser(ShiftTradeMatchReviewUserResponse receivingUser) {
        this.receivingUser = receivingUser;
        return this;
    }

    @ApiModelProperty(example="null", value="Details for the receivingUser side of the shift trade")
    @JsonProperty(value="receivingUser")
    public ShiftTradeMatchReviewUserResponse getReceivingUser() {
        return this.receivingUser;
    }

    public void setReceivingUser(ShiftTradeMatchReviewUserResponse receivingUser) {
        this.receivingUser = receivingUser;
    }

    public ShiftTradeMatchReviewResponse violations(List<ShiftTradeMatchViolation> violations) {
        this.violations = violations;
        return this;
    }

    @ApiModelProperty(example="null", value="Constraint violations introduced after being matched that would normally disallow a trade, but which can still be overridden by the shift trade administrator")
    @JsonProperty(value="violations")
    public List<ShiftTradeMatchViolation> getViolations() {
        return this.violations;
    }

    public void setViolations(List<ShiftTradeMatchViolation> violations) {
        this.violations = violations;
    }

    public ShiftTradeMatchReviewResponse adminReviewViolations(List<ShiftTradeMatchViolation> adminReviewViolations) {
        this.adminReviewViolations = adminReviewViolations;
        return this;
    }

    @ApiModelProperty(example="null", value="Constraint violations associated with this shift trade which require shift trade administrator review")
    @JsonProperty(value="adminReviewViolations")
    public List<ShiftTradeMatchViolation> getAdminReviewViolations() {
        return this.adminReviewViolations;
    }

    public void setAdminReviewViolations(List<ShiftTradeMatchViolation> adminReviewViolations) {
        this.adminReviewViolations = adminReviewViolations;
    }

    public ShiftTradeMatchReviewResponse unevaluatedRules(List<UnevaluatedRulesEnum> unevaluatedRules) {
        this.unevaluatedRules = unevaluatedRules;
        return this;
    }

    @ApiModelProperty(example="null", value="Unevaluated rules for this shift trade which require shift trade administrator review")
    @JsonProperty(value="unevaluatedRules")
    public List<UnevaluatedRulesEnum> getUnevaluatedRules() {
        return this.unevaluatedRules;
    }

    public void setUnevaluatedRules(List<UnevaluatedRulesEnum> unevaluatedRules) {
        this.unevaluatedRules = unevaluatedRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShiftTradeMatchReviewResponse shiftTradeMatchReviewResponse = (ShiftTradeMatchReviewResponse)o;
        return Objects.equals(this.initiatingUser, shiftTradeMatchReviewResponse.initiatingUser) && Objects.equals(this.receivingUser, shiftTradeMatchReviewResponse.receivingUser) && Objects.equals(this.violations, shiftTradeMatchReviewResponse.violations) && Objects.equals(this.adminReviewViolations, shiftTradeMatchReviewResponse.adminReviewViolations) && Objects.equals(this.unevaluatedRules, shiftTradeMatchReviewResponse.unevaluatedRules);
    }

    public int hashCode() {
        return Objects.hash(this.initiatingUser, this.receivingUser, this.violations, this.adminReviewViolations, this.unevaluatedRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShiftTradeMatchReviewResponse {\n");
        sb.append("    initiatingUser: ").append(this.toIndentedString(this.initiatingUser)).append("\n");
        sb.append("    receivingUser: ").append(this.toIndentedString(this.receivingUser)).append("\n");
        sb.append("    violations: ").append(this.toIndentedString(this.violations)).append("\n");
        sb.append("    adminReviewViolations: ").append(this.toIndentedString(this.adminReviewViolations)).append("\n");
        sb.append("    unevaluatedRules: ").append(this.toIndentedString(this.unevaluatedRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnevaluatedRulesEnumDeserializer.class)
    public static enum UnevaluatedRulesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PLANNINGPERIODMINPAIDTIME("PlanningPeriodMinPaidTime"),
        PLANNINGPERIODMAXPAIDTIME("PlanningPeriodMaxPaidTime"),
        MINIMUMTIMEBETWEENSHIFTS("MinimumTimeBetweenShifts");

        private String value;

        private UnevaluatedRulesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnevaluatedRulesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnevaluatedRulesEnum value : UnevaluatedRulesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnevaluatedRulesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnevaluatedRulesEnumDeserializer
    extends StdDeserializer<UnevaluatedRulesEnum> {
        public UnevaluatedRulesEnumDeserializer() {
            super(UnevaluatedRulesEnumDeserializer.class);
        }

        public UnevaluatedRulesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnevaluatedRulesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

