/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestSessionApp;
import com.mypurecloud.sdk.v2.model.KnowledgeGuestSessionContext;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KnowledgeGuestSession
implements Serializable {
    private String id = null;
    private KnowledgeGuestSessionApp app = null;
    private String customerId = null;
    private String pageUrl = null;
    private List<KnowledgeGuestSessionContext> contexts = null;
    private String journeySessionId = null;

    public KnowledgeGuestSession() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.contexts = new ArrayList<KnowledgeGuestSessionContext>();
        }
    }

    @ApiModelProperty(example="null", value="Session ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeGuestSession app(KnowledgeGuestSessionApp app) {
        this.app = app;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The app where the session is started.")
    @JsonProperty(value="app")
    public KnowledgeGuestSessionApp getApp() {
        return this.app;
    }

    public void setApp(KnowledgeGuestSessionApp app) {
        this.app = app;
    }

    public KnowledgeGuestSession customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="An arbitrary ID for the customer starting the session. Used to track multiple sessions started by the same customer.")
    @JsonProperty(value="customerId")
    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public KnowledgeGuestSession pageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of the page where the session is started.")
    @JsonProperty(value="pageUrl")
    public String getPageUrl() {
        return this.pageUrl;
    }

    public void setPageUrl(String pageUrl) {
        this.pageUrl = pageUrl;
    }

    public KnowledgeGuestSession contexts(List<KnowledgeGuestSessionContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    @ApiModelProperty(example="null", value="The session contexts.")
    @JsonProperty(value="contexts")
    public List<KnowledgeGuestSessionContext> getContexts() {
        return this.contexts;
    }

    public void setContexts(List<KnowledgeGuestSessionContext> contexts) {
        this.contexts = contexts;
    }

    public KnowledgeGuestSession journeySessionId(String journeySessionId) {
        this.journeySessionId = journeySessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="Journey session ID. Used to get the segments of the customer to filter search results.")
    @JsonProperty(value="journeySessionId")
    public String getJourneySessionId() {
        return this.journeySessionId;
    }

    public void setJourneySessionId(String journeySessionId) {
        this.journeySessionId = journeySessionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeGuestSession knowledgeGuestSession = (KnowledgeGuestSession)o;
        return Objects.equals(this.id, knowledgeGuestSession.id) && Objects.equals(this.app, knowledgeGuestSession.app) && Objects.equals(this.customerId, knowledgeGuestSession.customerId) && Objects.equals(this.pageUrl, knowledgeGuestSession.pageUrl) && Objects.equals(this.contexts, knowledgeGuestSession.contexts) && Objects.equals(this.journeySessionId, knowledgeGuestSession.journeySessionId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.app, this.customerId, this.pageUrl, this.contexts, this.journeySessionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeGuestSession {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("    customerId: ").append(this.toIndentedString(this.customerId)).append("\n");
        sb.append("    pageUrl: ").append(this.toIndentedString(this.pageUrl)).append("\n");
        sb.append("    contexts: ").append(this.toIndentedString(this.contexts)).append("\n");
        sb.append("    journeySessionId: ").append(this.toIndentedString(this.journeySessionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

