/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Must provide a valid value for exactly one of the fields in this class.")
public class DecisionTableColumnDefaultRowValue
implements Serializable {
    private String value = null;
    private SpecialEnum special = null;

    public DecisionTableColumnDefaultRowValue() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public DecisionTableColumnDefaultRowValue value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="A default string value for this column, will be cast to appropriate type according to the relevant contract schema property.")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public DecisionTableColumnDefaultRowValue special(SpecialEnum special) {
        this.special = special;
        return this;
    }

    @ApiModelProperty(example="null", value="A default special value enum for this column.")
    @JsonProperty(value="special")
    public SpecialEnum getSpecial() {
        return this.special;
    }

    public void setSpecial(SpecialEnum special) {
        this.special = special;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecisionTableColumnDefaultRowValue decisionTableColumnDefaultRowValue = (DecisionTableColumnDefaultRowValue)o;
        return Objects.equals(this.value, decisionTableColumnDefaultRowValue.value) && Objects.equals((Object)this.special, (Object)decisionTableColumnDefaultRowValue.special);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.special});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DecisionTableColumnDefaultRowValue {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    special: ").append(this.toIndentedString((Object)this.special)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SpecialEnumDeserializer.class)
    public static enum SpecialEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WILDCARD("Wildcard"),
        NULL("Null"),
        EMPTY("Empty"),
        CURRENTTIME("CurrentTime");

        private String value;

        private SpecialEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SpecialEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SpecialEnum value : SpecialEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SpecialEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SpecialEnumDeserializer
    extends StdDeserializer<SpecialEnum> {
        public SpecialEnumDeserializer() {
            super(SpecialEnumDeserializer.class);
        }

        public SpecialEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SpecialEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

