/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WfmVersionedEntityMetadata;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AdminTimeOffRequestPatch
implements Serializable {
    private StatusEnum status = null;
    private String activityCodeId = null;
    private Boolean paid = null;
    private String notes = null;
    private List<String> fullDayManagementUnitDates = null;
    private List<Date> partialDayStartDateTimes = null;
    private Integer dailyDurationMinutes = null;
    private List<Integer> durationMinutes = null;
    private List<Integer> payableMinutes = null;
    private WfmVersionedEntityMetadata metadata = null;

    public AdminTimeOffRequestPatch() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.fullDayManagementUnitDates = new ArrayList<String>();
            this.partialDayStartDateTimes = new ArrayList<Date>();
            this.durationMinutes = new ArrayList<Integer>();
            this.payableMinutes = new ArrayList<Integer>();
        }
    }

    public AdminTimeOffRequestPatch status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of this time off request")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AdminTimeOffRequestPatch activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the activity code associated with this time off request. Activity code must be of the TimeOff category")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public AdminTimeOffRequestPatch paid(Boolean paid) {
        this.paid = paid;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether this is a paid time off request")
    @JsonProperty(value="paid")
    public Boolean getPaid() {
        return this.paid;
    }

    public void setPaid(Boolean paid) {
        this.paid = paid;
    }

    public AdminTimeOffRequestPatch notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes about the time off request")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public AdminTimeOffRequestPatch fullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of dates in yyyy-MM-dd format. Should be interpreted in the management unit's configured time zone.")
    @JsonProperty(value="fullDayManagementUnitDates")
    public List<String> getFullDayManagementUnitDates() {
        return this.fullDayManagementUnitDates;
    }

    public void setFullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
    }

    public AdminTimeOffRequestPatch partialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of start date-times in ISO-8601 format for partial day requests.")
    @JsonProperty(value="partialDayStartDateTimes")
    public List<Date> getPartialDayStartDateTimes() {
        return this.partialDayStartDateTimes;
    }

    public void setPartialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
    }

    public AdminTimeOffRequestPatch dailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="The daily duration of this time off request in minutes")
    @JsonProperty(value="dailyDurationMinutes")
    public Integer getDailyDurationMinutes() {
        return this.dailyDurationMinutes;
    }

    public void setDailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
    }

    public AdminTimeOffRequestPatch durationMinutes(List<Integer> durationMinutes) {
        this.durationMinutes = durationMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Daily durations for each day of this time off request in minutes")
    @JsonProperty(value="durationMinutes")
    public List<Integer> getDurationMinutes() {
        return this.durationMinutes;
    }

    public void setDurationMinutes(List<Integer> durationMinutes) {
        this.durationMinutes = durationMinutes;
    }

    public AdminTimeOffRequestPatch payableMinutes(List<Integer> payableMinutes) {
        this.payableMinutes = payableMinutes;
        return this;
    }

    @ApiModelProperty(example="null", value="Payable minutes for each day of this time off request")
    @JsonProperty(value="payableMinutes")
    public List<Integer> getPayableMinutes() {
        return this.payableMinutes;
    }

    public void setPayableMinutes(List<Integer> payableMinutes) {
        this.payableMinutes = payableMinutes;
    }

    public AdminTimeOffRequestPatch metadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version metadata for the time off request")
    @JsonProperty(value="metadata")
    public WfmVersionedEntityMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(WfmVersionedEntityMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdminTimeOffRequestPatch adminTimeOffRequestPatch = (AdminTimeOffRequestPatch)o;
        return Objects.equals((Object)this.status, (Object)adminTimeOffRequestPatch.status) && Objects.equals(this.activityCodeId, adminTimeOffRequestPatch.activityCodeId) && Objects.equals(this.paid, adminTimeOffRequestPatch.paid) && Objects.equals(this.notes, adminTimeOffRequestPatch.notes) && Objects.equals(this.fullDayManagementUnitDates, adminTimeOffRequestPatch.fullDayManagementUnitDates) && Objects.equals(this.partialDayStartDateTimes, adminTimeOffRequestPatch.partialDayStartDateTimes) && Objects.equals(this.dailyDurationMinutes, adminTimeOffRequestPatch.dailyDurationMinutes) && Objects.equals(this.durationMinutes, adminTimeOffRequestPatch.durationMinutes) && Objects.equals(this.payableMinutes, adminTimeOffRequestPatch.payableMinutes) && Objects.equals(this.metadata, adminTimeOffRequestPatch.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.activityCodeId, this.paid, this.notes, this.fullDayManagementUnitDates, this.partialDayStartDateTimes, this.dailyDurationMinutes, this.durationMinutes, this.payableMinutes, this.metadata});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdminTimeOffRequestPatch {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    paid: ").append(this.toIndentedString(this.paid)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    fullDayManagementUnitDates: ").append(this.toIndentedString(this.fullDayManagementUnitDates)).append("\n");
        sb.append("    partialDayStartDateTimes: ").append(this.toIndentedString(this.partialDayStartDateTimes)).append("\n");
        sb.append("    dailyDurationMinutes: ").append(this.toIndentedString(this.dailyDurationMinutes)).append("\n");
        sb.append("    durationMinutes: ").append(this.toIndentedString(this.durationMinutes)).append("\n");
        sb.append("    payableMinutes: ").append(this.toIndentedString(this.payableMinutes)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        APPROVED("APPROVED"),
        DENIED("DENIED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

