/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MatchTestResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Results of a matching expression")
public class MatchCriteriaTestResult
implements Serializable {
    private String jsonPath = null;
    private OperatorEnum operator = null;
    private JsonNode value = null;
    private List<JsonNode> values = null;
    private String generatedJsonPathCondition = null;
    private Boolean match = null;
    private List<MatchTestResult> jsonPathExtraction = null;

    public MatchCriteriaTestResult() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.values = new ArrayList<JsonNode>();
            this.jsonPathExtraction = new ArrayList<MatchTestResult>();
        }
    }

    public MatchCriteriaTestResult jsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
        return this;
    }

    @ApiModelProperty(example="null", value="The Goessner json path of the field to match")
    @JsonProperty(value="jsonPath")
    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public MatchCriteriaTestResult operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of operation to perform for matching check")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public MatchCriteriaTestResult value(JsonNode value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The value to match on. Only one of value and values can be included")
    @JsonProperty(value="value")
    public JsonNode getValue() {
        return this.value;
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    public MatchCriteriaTestResult values(List<JsonNode> values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of values to match on. Only one of value and values can be included")
    @JsonProperty(value="values")
    public List<JsonNode> getValues() {
        return this.values;
    }

    public void setValues(List<JsonNode> values) {
        this.values = values;
    }

    public MatchCriteriaTestResult generatedJsonPathCondition(String generatedJsonPathCondition) {
        this.generatedJsonPathCondition = generatedJsonPathCondition;
        return this;
    }

    @ApiModelProperty(example="null", value="The generated json path condition")
    @JsonProperty(value="generatedJsonPathCondition")
    public String getGeneratedJsonPathCondition() {
        return this.generatedJsonPathCondition;
    }

    public void setGeneratedJsonPathCondition(String generatedJsonPathCondition) {
        this.generatedJsonPathCondition = generatedJsonPathCondition;
    }

    public MatchCriteriaTestResult match(Boolean match) {
        this.match = match;
        return this;
    }

    @ApiModelProperty(example="null", value="Did the generated json path condition match")
    @JsonProperty(value="match")
    public Boolean getMatch() {
        return this.match;
    }

    public void setMatch(Boolean match) {
        this.match = match;
    }

    public MatchCriteriaTestResult jsonPathExtraction(List<MatchTestResult> jsonPathExtraction) {
        this.jsonPathExtraction = jsonPathExtraction;
        return this;
    }

    @ApiModelProperty(example="null", value="The json paths and their values that were compared")
    @JsonProperty(value="jsonPathExtraction")
    public List<MatchTestResult> getJsonPathExtraction() {
        return this.jsonPathExtraction;
    }

    public void setJsonPathExtraction(List<MatchTestResult> jsonPathExtraction) {
        this.jsonPathExtraction = jsonPathExtraction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchCriteriaTestResult matchCriteriaTestResult = (MatchCriteriaTestResult)o;
        return Objects.equals(this.jsonPath, matchCriteriaTestResult.jsonPath) && Objects.equals((Object)this.operator, (Object)matchCriteriaTestResult.operator) && Objects.equals(this.value, matchCriteriaTestResult.value) && Objects.equals(this.values, matchCriteriaTestResult.values) && Objects.equals(this.generatedJsonPathCondition, matchCriteriaTestResult.generatedJsonPathCondition) && Objects.equals(this.match, matchCriteriaTestResult.match) && Objects.equals(this.jsonPathExtraction, matchCriteriaTestResult.jsonPathExtraction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonPath, this.operator, this.value, this.values, this.generatedJsonPathCondition, this.match, this.jsonPathExtraction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchCriteriaTestResult {\n");
        sb.append("    jsonPath: ").append(this.toIndentedString(this.jsonPath)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    generatedJsonPathCondition: ").append(this.toIndentedString(this.generatedJsonPathCondition)).append("\n");
        sb.append("    match: ").append(this.toIndentedString(this.match)).append("\n");
        sb.append("    jsonPathExtraction: ").append(this.toIndentedString(this.jsonPathExtraction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GREATERTHANOREQUAL("GreaterThanOrEqual"),
        LESSTHANOREQUAL("LessThanOrEqual"),
        EQUAL("Equal"),
        NOTEQUAL("NotEqual"),
        LESSTHAN("LessThan"),
        GREATERTHAN("GreaterThan"),
        NOTIN("NotIn"),
        IN("In"),
        CONTAINS("Contains"),
        ALL("All"),
        EXISTS("Exists"),
        SIZE("Size");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

