/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MessageInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Status information for an Integration.")
public class IntegrationStatusInfo
implements Serializable {
    private CodeEnum code = null;
    private String effective = null;
    private MessageInfo detail = null;
    private Date lastUpdated = null;

    public IntegrationStatusInfo() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Machine-readable status as reported by the integration.")
    @JsonProperty(value="code")
    public CodeEnum getCode() {
        return this.code;
    }

    @ApiModelProperty(example="null", value="Localized, human-readable, effective status of the integration.")
    @JsonProperty(value="effective")
    public String getEffective() {
        return this.effective;
    }

    @ApiModelProperty(example="null", value="Localizable status details for the integration.")
    @JsonProperty(value="detail")
    public MessageInfo getDetail() {
        return this.detail;
    }

    @ApiModelProperty(example="null", value="Date and time (in UTC) when the integration status (i.e. the code field) was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="lastUpdated")
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationStatusInfo integrationStatusInfo = (IntegrationStatusInfo)o;
        return Objects.equals((Object)this.code, (Object)integrationStatusInfo.code) && Objects.equals(this.effective, integrationStatusInfo.effective) && Objects.equals(this.detail, integrationStatusInfo.detail) && Objects.equals(this.lastUpdated, integrationStatusInfo.lastUpdated);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.effective, this.detail, this.lastUpdated});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationStatusInfo {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    effective: ").append(this.toIndentedString(this.effective)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CodeEnumDeserializer.class)
    public static enum CodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("ACTIVE"),
        ACTIVATING("ACTIVATING"),
        INACTIVE("INACTIVE"),
        DEACTIVATING("DEACTIVATING"),
        ERROR("ERROR");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CodeEnum value : CodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CodeEnumDeserializer
    extends StdDeserializer<CodeEnum> {
        public CodeEnumDeserializer() {
            super(CodeEnumDeserializer.class);
        }

        public CodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

