/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContactEnrichOptions;
import com.mypurecloud.sdk.v2.model.ContactIdentifier;
import com.mypurecloud.sdk.v2.model.EnrichFieldRules;
import com.mypurecloud.sdk.v2.model.ExternalContact;
import com.mypurecloud.sdk.v2.model.WritableStarrableDivision;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ContactEnrichRequest
implements Serializable {
    private String id = null;
    private WritableStarrableDivision division = null;
    private List<ContactIdentifier> matchingIdentifiers = null;
    private ActionEnum action = null;
    private ExternalContact contact = null;
    private EnrichFieldRules fieldRules = null;
    private ContactEnrichOptions options = null;

    public ContactEnrichRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.matchingIdentifiers = new ArrayList<ContactIdentifier>();
        }
    }

    public ContactEnrichRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A user-specified tracker string, only useful in the Bulk-Enrich API. If one Bulk-Enrich operation in a request fails, the requested operation will be repeated in the Bulk API response, including this id field, allowing associating of request and response operations.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContactEnrichRequest division(WritableStarrableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public WritableStarrableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableStarrableDivision division) {
        this.division = division;
    }

    public ContactEnrichRequest matchingIdentifiers(List<ContactIdentifier> matchingIdentifiers) {
        this.matchingIdentifiers = matchingIdentifiers;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="An ordered list of one or more Identifiers which might each be claimed by a Contact. `action` describes what to do with any possibly matching Contacts. Identifier lookups will occur in the order specified here.")
    @JsonProperty(value="matchingIdentifiers")
    public List<ContactIdentifier> getMatchingIdentifiers() {
        return this.matchingIdentifiers;
    }

    public void setMatchingIdentifiers(List<ContactIdentifier> matchingIdentifiers) {
        this.matchingIdentifiers = matchingIdentifiers;
    }

    public ContactEnrichRequest action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The action that should be taken based on any Contacts found by `matchingIdentifiers`.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public ContactEnrichRequest contact(ExternalContact contact) {
        this.contact = contact;
        return this;
    }

    @ApiModelProperty(example="null", value="Data to be added, either as an update to an existing Contact or the body of a new Contact. Omitting a field in this contract means that it will be treated as null in the `fieldRules` logic.")
    @JsonProperty(value="contact")
    public ExternalContact getContact() {
        return this.contact;
    }

    public void setContact(ExternalContact contact) {
        this.contact = contact;
    }

    public ContactEnrichRequest fieldRules(EnrichFieldRules fieldRules) {
        this.fieldRules = fieldRules;
        return this;
    }

    @ApiModelProperty(example="null", value="Logic describing how to combine data from the submitted request with data found in the database.")
    @JsonProperty(value="fieldRules")
    public EnrichFieldRules getFieldRules() {
        return this.fieldRules;
    }

    public void setFieldRules(EnrichFieldRules fieldRules) {
        this.fieldRules = fieldRules;
    }

    public ContactEnrichRequest options(ContactEnrichOptions options) {
        this.options = options;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional options modifying the behavior of the API operation.")
    @JsonProperty(value="options")
    public ContactEnrichOptions getOptions() {
        return this.options;
    }

    public void setOptions(ContactEnrichOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactEnrichRequest contactEnrichRequest = (ContactEnrichRequest)o;
        return Objects.equals(this.id, contactEnrichRequest.id) && Objects.equals(this.division, contactEnrichRequest.division) && Objects.equals(this.matchingIdentifiers, contactEnrichRequest.matchingIdentifiers) && Objects.equals((Object)this.action, (Object)contactEnrichRequest.action) && Objects.equals(this.contact, contactEnrichRequest.contact) && Objects.equals(this.fieldRules, contactEnrichRequest.fieldRules) && Objects.equals(this.options, contactEnrichRequest.options);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.division, this.matchingIdentifiers, this.action, this.contact, this.fieldRules, this.options});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactEnrichRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    matchingIdentifiers: ").append(this.toIndentedString(this.matchingIdentifiers)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    fieldRules: ").append(this.toIndentedString(this.fieldRules)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MERGE("Merge"),
        UPSERT("Upsert"),
        UPDATE("Update"),
        INSERT("Insert");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

