/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationReason;
import com.mypurecloud.sdk.v2.model.OpenInboundMessagingReceiptChannel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Open Messaging rich media message structure")
public class OpenInboundNormalizedReceipt
implements Serializable {
    private String id = null;
    private OpenInboundMessagingReceiptChannel channel = null;
    private StatusEnum status = null;
    private List<ConversationReason> reasons = null;
    private Boolean isFinalReceipt = null;

    public OpenInboundNormalizedReceipt() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.reasons = new ArrayList<ConversationReason>();
        }
    }

    public OpenInboundNormalizedReceipt id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The original unique message Id generated by the messaging platform, that this receipt message is referencing.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public OpenInboundNormalizedReceipt channel(OpenInboundMessagingReceiptChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenInboundMessagingReceiptChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenInboundMessagingReceiptChannel channel) {
        this.channel = channel;
    }

    public OpenInboundNormalizedReceipt status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message receipt status.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public OpenInboundNormalizedReceipt reasons(List<ConversationReason> reasons) {
        this.reasons = reasons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of reasons for a message receipt that indicates the message has failed. Only used with Failed status.")
    @JsonProperty(value="reasons")
    public List<ConversationReason> getReasons() {
        return this.reasons;
    }

    public void setReasons(List<ConversationReason> reasons) {
        this.reasons = reasons;
    }

    public OpenInboundNormalizedReceipt isFinalReceipt(Boolean isFinalReceipt) {
        this.isFinalReceipt = isFinalReceipt;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if this is the last message receipt for this message, or if another message receipt can be expected.")
    @JsonProperty(value="isFinalReceipt")
    public Boolean getIsFinalReceipt() {
        return this.isFinalReceipt;
    }

    public void setIsFinalReceipt(Boolean isFinalReceipt) {
        this.isFinalReceipt = isFinalReceipt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenInboundNormalizedReceipt openInboundNormalizedReceipt = (OpenInboundNormalizedReceipt)o;
        return Objects.equals(this.id, openInboundNormalizedReceipt.id) && Objects.equals(this.channel, openInboundNormalizedReceipt.channel) && Objects.equals((Object)this.status, (Object)openInboundNormalizedReceipt.status) && Objects.equals(this.reasons, openInboundNormalizedReceipt.reasons) && Objects.equals(this.isFinalReceipt, openInboundNormalizedReceipt.isFinalReceipt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.status, this.reasons, this.isFinalReceipt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenInboundNormalizedReceipt {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    reasons: ").append(this.toIndentedString(this.reasons)).append("\n");
        sb.append("    isFinalReceipt: ").append(this.toIndentedString(this.isFinalReceipt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SENT("Sent"),
        DELIVERED("Delivered"),
        FAILED("Failed"),
        PUBLISHED("Published"),
        REMOVED("Removed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

