/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneyViewVersionRequest {
    private String viewId;
    private String versionId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public GetJourneyViewVersionRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public GetJourneyViewVersionRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneyViewVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetJourneyViewVersionRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/views/{viewId}/versions/{versionId}").withPathParameter("viewId", this.viewId).withPathParameter("versionId", this.versionId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String versionId) {
        return new Builder().withRequiredParams(viewId, versionId);
    }

    public static class Builder {
        private final GetJourneyViewVersionRequest request = new GetJourneyViewVersionRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withRequiredParams(String viewId, String versionId) {
            this.request.setViewId(viewId);
            this.request.setVersionId(versionId);
            return this;
        }

        public GetJourneyViewVersionRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionRequest.");
            }
            if (this.request.versionId == null) {
                throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetJourneyViewVersionRequest.");
            }
            return this.request;
        }
    }
}

