/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.EvaluationSettingsAssignee;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EvaluationSettings
implements Serializable {
    private Boolean revisionsEnabled = null;
    private Boolean disputesEnabled = null;
    private Integer disputesAllowedPerEvaluation = null;
    private List<EvaluationSettingsAssignee> disputesAssignees = null;

    public EvaluationSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.disputesAssignees = new ArrayList<EvaluationSettingsAssignee>();
        }
    }

    public EvaluationSettings revisionsEnabled(Boolean revisionsEnabled) {
        this.revisionsEnabled = revisionsEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether revisions are allowed for evaluations. When enabled, rescoring creates a new version of the evaluation and retracts the existing evaluation version. Does not apply for calibration evaluations.")
    @JsonProperty(value="revisionsEnabled")
    public Boolean getRevisionsEnabled() {
        return this.revisionsEnabled;
    }

    public void setRevisionsEnabled(Boolean revisionsEnabled) {
        this.revisionsEnabled = revisionsEnabled;
    }

    public EvaluationSettings disputesEnabled(Boolean disputesEnabled) {
        this.disputesEnabled = disputesEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether disputes are allowed for evaluations. Does not apply for calibration evaluations.")
    @JsonProperty(value="disputesEnabled")
    public Boolean getDisputesEnabled() {
        return this.disputesEnabled;
    }

    public void setDisputesEnabled(Boolean disputesEnabled) {
        this.disputesEnabled = disputesEnabled;
    }

    public EvaluationSettings disputesAllowedPerEvaluation(Integer disputesAllowedPerEvaluation) {
        this.disputesAllowedPerEvaluation = disputesAllowedPerEvaluation;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum number of disputes allowed for an evaluation.")
    @JsonProperty(value="disputesAllowedPerEvaluation")
    public Integer getDisputesAllowedPerEvaluation() {
        return this.disputesAllowedPerEvaluation;
    }

    public void setDisputesAllowedPerEvaluation(Integer disputesAllowedPerEvaluation) {
        this.disputesAllowedPerEvaluation = disputesAllowedPerEvaluation;
    }

    public EvaluationSettings disputesAssignees(List<EvaluationSettingsAssignee> disputesAssignees) {
        this.disputesAssignees = disputesAssignees;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of assignees responsible for handling each dispute. This list size needs to be equal to disputesAllowedPerEvaluation.")
    @JsonProperty(value="disputesAssignees")
    public List<EvaluationSettingsAssignee> getDisputesAssignees() {
        return this.disputesAssignees;
    }

    public void setDisputesAssignees(List<EvaluationSettingsAssignee> disputesAssignees) {
        this.disputesAssignees = disputesAssignees;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationSettings evaluationSettings = (EvaluationSettings)o;
        return Objects.equals(this.revisionsEnabled, evaluationSettings.revisionsEnabled) && Objects.equals(this.disputesEnabled, evaluationSettings.disputesEnabled) && Objects.equals(this.disputesAllowedPerEvaluation, evaluationSettings.disputesAllowedPerEvaluation) && Objects.equals(this.disputesAssignees, evaluationSettings.disputesAssignees);
    }

    public int hashCode() {
        return Objects.hash(this.revisionsEnabled, this.disputesEnabled, this.disputesAllowedPerEvaluation, this.disputesAssignees);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EvaluationSettings {\n");
        sb.append("    revisionsEnabled: ").append(this.toIndentedString(this.revisionsEnabled)).append("\n");
        sb.append("    disputesEnabled: ").append(this.toIndentedString(this.disputesEnabled)).append("\n");
        sb.append("    disputesAllowedPerEvaluation: ").append(this.toIndentedString(this.disputesAllowedPerEvaluation)).append("\n");
        sb.append("    disputesAssignees: ").append(this.toIndentedString(this.disputesAssignees)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

