/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationPushFailedMessageReferences;
import com.mypurecloud.sdk.v2.model.ConversationPushNotificationMessageLabel;
import com.mypurecloud.sdk.v2.model.ConversationPushProviderIntegration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A Push object")
public class ConversationContentPush
implements Serializable {
    private DeviceTypeEnum deviceType = null;
    private String deviceTokenId = null;
    private String deviceToken = null;
    private List<ConversationPushFailedMessageReferences> failedMessages = null;
    private ConversationPushNotificationMessageLabel notificationMessage = null;
    private ConversationPushProviderIntegration pushProviderIntegration = null;
    private Long expiration = null;

    public ConversationContentPush() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.failedMessages = new ArrayList<ConversationPushFailedMessageReferences>();
        }
    }

    public ConversationContentPush deviceType(DeviceTypeEnum deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The device type used to send the push notification")
    @JsonProperty(value="deviceType")
    public DeviceTypeEnum getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceTypeEnum deviceType) {
        this.deviceType = deviceType;
    }

    public ConversationContentPush deviceTokenId(String deviceTokenId) {
        this.deviceTokenId = deviceTokenId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique Id of the device token")
    @JsonProperty(value="deviceTokenId")
    public String getDeviceTokenId() {
        return this.deviceTokenId;
    }

    public void setDeviceTokenId(String deviceTokenId) {
        this.deviceTokenId = deviceTokenId;
    }

    public ConversationContentPush deviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="device token from the notification provider")
    @JsonProperty(value="deviceToken")
    public String getDeviceToken() {
        return this.deviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        this.deviceToken = deviceToken;
    }

    public ConversationContentPush failedMessages(List<ConversationPushFailedMessageReferences> failedMessages) {
        this.failedMessages = failedMessages;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="MessageIds failed to be sent which trigger the push event")
    @JsonProperty(value="failedMessages")
    public List<ConversationPushFailedMessageReferences> getFailedMessages() {
        return this.failedMessages;
    }

    public void setFailedMessages(List<ConversationPushFailedMessageReferences> failedMessages) {
        this.failedMessages = failedMessages;
    }

    public ConversationContentPush notificationMessage(ConversationPushNotificationMessageLabel notificationMessage) {
        this.notificationMessage = notificationMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Title and body localized according to deployment")
    @JsonProperty(value="notificationMessage")
    public ConversationPushNotificationMessageLabel getNotificationMessage() {
        return this.notificationMessage;
    }

    public void setNotificationMessage(ConversationPushNotificationMessageLabel notificationMessage) {
        this.notificationMessage = notificationMessage;
    }

    public ConversationContentPush pushProviderIntegration(ConversationPushProviderIntegration pushProviderIntegration) {
        this.pushProviderIntegration = pushProviderIntegration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Push provider integrations details configured on the deployment")
    @JsonProperty(value="pushProviderIntegration")
    public ConversationPushProviderIntegration getPushProviderIntegration() {
        return this.pushProviderIntegration;
    }

    public void setPushProviderIntegration(ConversationPushProviderIntegration pushProviderIntegration) {
        this.pushProviderIntegration = pushProviderIntegration;
    }

    public ConversationContentPush expiration(Long expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The time to live of the pushed message")
    @JsonProperty(value="expiration")
    public Long getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Long expiration) {
        this.expiration = expiration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentPush conversationContentPush = (ConversationContentPush)o;
        return Objects.equals((Object)this.deviceType, (Object)conversationContentPush.deviceType) && Objects.equals(this.deviceTokenId, conversationContentPush.deviceTokenId) && Objects.equals(this.deviceToken, conversationContentPush.deviceToken) && Objects.equals(this.failedMessages, conversationContentPush.failedMessages) && Objects.equals(this.notificationMessage, conversationContentPush.notificationMessage) && Objects.equals(this.pushProviderIntegration, conversationContentPush.pushProviderIntegration) && Objects.equals(this.expiration, conversationContentPush.expiration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceType, this.deviceTokenId, this.deviceToken, this.failedMessages, this.notificationMessage, this.pushProviderIntegration, this.expiration});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentPush {\n");
        sb.append("    deviceType: ").append(this.toIndentedString((Object)this.deviceType)).append("\n");
        sb.append("    deviceTokenId: ").append(this.toIndentedString(this.deviceTokenId)).append("\n");
        sb.append("    deviceToken: ").append(this.toIndentedString(this.deviceToken)).append("\n");
        sb.append("    failedMessages: ").append(this.toIndentedString(this.failedMessages)).append("\n");
        sb.append("    notificationMessage: ").append(this.toIndentedString(this.notificationMessage)).append("\n");
        sb.append("    pushProviderIntegration: ").append(this.toIndentedString(this.pushProviderIntegration)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DeviceTypeEnumDeserializer.class)
    public static enum DeviceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ANDROID("Android"),
        IOS("IOS");

        private String value;

        private DeviceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DeviceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DeviceTypeEnum value : DeviceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DeviceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DeviceTypeEnumDeserializer
    extends StdDeserializer<DeviceTypeEnum> {
        public DeviceTypeEnumDeserializer() {
            super(DeviceTypeEnumDeserializer.class);
        }

        public DeviceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DeviceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

