/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AudioState;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AudioUpdatedEvent
implements Serializable {
    private String eventId = null;
    private Date eventDateTime = null;
    private String conversationId = null;
    private String communicationId = null;
    private AudioState audioState = null;

    public AudioUpdatedEvent() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AudioUpdatedEvent eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique (V4 UUID) eventId for this event")
    @JsonProperty(value="eventId")
    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public AudioUpdatedEvent eventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A Date Time representing the time this event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDateTime")
    public Date getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(Date eventDateTime) {
        this.eventDateTime = eventDateTime;
    }

    public AudioUpdatedEvent conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this conversation")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public AudioUpdatedEvent communicationId(String communicationId) {
        this.communicationId = communicationId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A unique Id (V4 UUID) identifying this communication")
    @JsonProperty(value="communicationId")
    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public AudioUpdatedEvent audioState(AudioState audioState) {
        this.audioState = audioState;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The updated audioState for the target communication.")
    @JsonProperty(value="audioState")
    public AudioState getAudioState() {
        return this.audioState;
    }

    public void setAudioState(AudioState audioState) {
        this.audioState = audioState;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioUpdatedEvent audioUpdatedEvent = (AudioUpdatedEvent)o;
        return Objects.equals(this.eventId, audioUpdatedEvent.eventId) && Objects.equals(this.eventDateTime, audioUpdatedEvent.eventDateTime) && Objects.equals(this.conversationId, audioUpdatedEvent.conversationId) && Objects.equals(this.communicationId, audioUpdatedEvent.communicationId) && Objects.equals(this.audioState, audioUpdatedEvent.audioState);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.eventDateTime, this.conversationId, this.communicationId, this.audioState);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AudioUpdatedEvent {\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventDateTime: ").append(this.toIndentedString(this.eventDateTime)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    communicationId: ").append(this.toIndentedString(this.communicationId)).append("\n");
        sb.append("    audioState: ").append(this.toIndentedString(this.audioState)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

