/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Segment
implements Serializable {
    private Date startTime = null;
    private Date endTime = null;
    private String type = null;
    private String howEnded = null;
    private String disconnectType = null;

    public Segment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Segment startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The timestamp when this segment began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Segment endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The timestamp when this segment ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Segment type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The activity taking place for the participant in the segment.")
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Segment howEnded(String howEnded) {
        this.howEnded = howEnded;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the event that ended the segment.")
    @JsonProperty(value="howEnded")
    public String getHowEnded() {
        return this.howEnded;
    }

    public void setHowEnded(String howEnded) {
        this.howEnded = howEnded;
    }

    public Segment disconnectType(String disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the event that disconnected the segment")
    @JsonProperty(value="disconnectType")
    public String getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(String disconnectType) {
        this.disconnectType = disconnectType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return Objects.equals(this.startTime, segment.startTime) && Objects.equals(this.endTime, segment.endTime) && Objects.equals(this.type, segment.type) && Objects.equals(this.howEnded, segment.howEnded) && Objects.equals(this.disconnectType, segment.disconnectType);
    }

    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.type, this.howEnded, this.disconnectType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Segment {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    howEnded: ").append(this.toIndentedString(this.howEnded)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString(this.disconnectType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

