/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.JourneyView;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class JourneyViewJob
implements Serializable {
    private String id = null;
    private Date dateCreated = null;
    private Date dateCompleted = null;
    private StatusEnum status = null;
    private JourneyView journeyView = null;
    private Date dateCompletionEstimated = null;
    private Long estimatedCompletionMargin = null;
    private String userId = null;
    private String selfUri = null;

    public JourneyViewJob() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp of execution. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp of completion. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public JourneyViewJob status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public JourneyViewJob journeyView(JourneyView journeyView) {
        this.journeyView = journeyView;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The journey view for which the job is executed")
    @JsonProperty(value="journeyView")
    public JourneyView getJourneyView() {
        return this.journeyView;
    }

    public void setJourneyView(JourneyView journeyView) {
        this.journeyView = journeyView;
    }

    @ApiModelProperty(example="null", required=true, value="Timestamp for the estimated time of completion. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompletionEstimated")
    public Date getDateCompletionEstimated() {
        return this.dateCompletionEstimated;
    }

    @ApiModelProperty(example="null", required=true, value="Margin of error of the estimated time of completion")
    @JsonProperty(value="estimatedCompletionMargin")
    public Long getEstimatedCompletionMargin() {
        return this.estimatedCompletionMargin;
    }

    @ApiModelProperty(example="null", required=true, value="Id of the user who submitted the request")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneyViewJob journeyViewJob = (JourneyViewJob)o;
        return Objects.equals(this.id, journeyViewJob.id) && Objects.equals(this.dateCreated, journeyViewJob.dateCreated) && Objects.equals(this.dateCompleted, journeyViewJob.dateCompleted) && Objects.equals((Object)this.status, (Object)journeyViewJob.status) && Objects.equals(this.journeyView, journeyViewJob.journeyView) && Objects.equals(this.dateCompletionEstimated, journeyViewJob.dateCompletionEstimated) && Objects.equals(this.estimatedCompletionMargin, journeyViewJob.estimatedCompletionMargin) && Objects.equals(this.userId, journeyViewJob.userId) && Objects.equals(this.selfUri, journeyViewJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.dateCreated, this.dateCompleted, this.status, this.journeyView, this.dateCompletionEstimated, this.estimatedCompletionMargin, this.userId, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneyViewJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    journeyView: ").append(this.toIndentedString(this.journeyView)).append("\n");
        sb.append("    dateCompletionEstimated: ").append(this.toIndentedString(this.dateCompletionEstimated)).append("\n");
        sb.append("    estimatedCompletionMargin: ").append(this.toIndentedString(this.estimatedCompletionMargin)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACCEPTED("Accepted"),
        EXECUTING("Executing"),
        COMPLETE("Complete"),
        FAILED("Failed"),
        CANCELLED("Cancelled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

