/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class BillingProduct
implements Serializable {
    private String id = null;
    private String sku = null;
    private String name = null;
    private UnitOfMeasureEnum unitOfMeasure = null;

    public BillingProduct() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public BillingProduct sku(String sku) {
        this.sku = sku;
        return this;
    }

    @ApiModelProperty(example="null", value="The product associated with the fund.")
    @JsonProperty(value="sku")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public BillingProduct name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the product.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BillingProduct unitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    @ApiModelProperty(example="null", value="The unit of measure for the product.")
    @JsonProperty(value="unitOfMeasure")
    public UnitOfMeasureEnum getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(UnitOfMeasureEnum unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BillingProduct billingProduct = (BillingProduct)o;
        return Objects.equals(this.id, billingProduct.id) && Objects.equals(this.sku, billingProduct.sku) && Objects.equals(this.name, billingProduct.name) && Objects.equals((Object)this.unitOfMeasure, (Object)billingProduct.unitOfMeasure);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.sku, this.name, this.unitOfMeasure});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BillingProduct {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unitOfMeasure: ").append(this.toIndentedString((Object)this.unitOfMeasure)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=UnitOfMeasureEnumDeserializer.class)
    public static enum UnitOfMeasureEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("Call"),
        CHARACTER("Character"),
        CONVERSATION("Conversation"),
        COURSE("Course"),
        DAY("Day"),
        EACH("Each"),
        EMPLOYEE("Employee"),
        ENGAGEMENT("Engagement"),
        EVENT("Event"),
        EXAM("Exam"),
        GB("GB"),
        HOUR("Hour"),
        INSTANCE("Instance"),
        INTERACTION("Interaction"),
        INVOCATION("Invocation"),
        MESSAGE("Message"),
        MILLIONCHARACTERS("MillionCharacters"),
        MINUTE("Minute"),
        PERSON("Person"),
        PHONENUMBER("PhoneNumber"),
        PORT("Port"),
        SEGMENT("Segment"),
        SESSION("Session"),
        STREAM("Stream"),
        TOKEN("Token"),
        TRANSACTION("Transaction"),
        TURN("Turn"),
        UNIT("Unit"),
        USER("User");

        private String value;

        private UnitOfMeasureEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UnitOfMeasureEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (UnitOfMeasureEnum value : UnitOfMeasureEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return UnitOfMeasureEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class UnitOfMeasureEnumDeserializer
    extends StdDeserializer<UnitOfMeasureEnum> {
        public UnitOfMeasureEnumDeserializer() {
            super(UnitOfMeasureEnumDeserializer.class);
        }

        public UnitOfMeasureEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return UnitOfMeasureEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

