/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.WorkitemQueryJobError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class WorkitemQueryJobResponse
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private Date dateStarted = null;
    private Date dateFinished = null;
    private WorkitemQueryJobError error = null;
    private String selfUri = null;

    public WorkitemQueryJobResponse() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WorkitemQueryJobResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The state of the query job")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public WorkitemQueryJobResponse dateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the job was started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStarted")
    public Date getDateStarted() {
        return this.dateStarted;
    }

    public void setDateStarted(Date dateStarted) {
        this.dateStarted = dateStarted;
    }

    public WorkitemQueryJobResponse dateFinished(Date dateFinished) {
        this.dateFinished = dateFinished;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the job finished. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateFinished")
    public Date getDateFinished() {
        return this.dateFinished;
    }

    public void setDateFinished(Date dateFinished) {
        this.dateFinished = dateFinished;
    }

    public WorkitemQueryJobResponse error(WorkitemQueryJobError error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="The error associated with the query job, if the state is Failed")
    @JsonProperty(value="error")
    public WorkitemQueryJobError getError() {
        return this.error;
    }

    public void setError(WorkitemQueryJobError error) {
        this.error = error;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkitemQueryJobResponse workitemQueryJobResponse = (WorkitemQueryJobResponse)o;
        return Objects.equals(this.id, workitemQueryJobResponse.id) && Objects.equals((Object)this.state, (Object)workitemQueryJobResponse.state) && Objects.equals(this.dateStarted, workitemQueryJobResponse.dateStarted) && Objects.equals(this.dateFinished, workitemQueryJobResponse.dateFinished) && Objects.equals(this.error, workitemQueryJobResponse.error) && Objects.equals(this.selfUri, workitemQueryJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.dateStarted, this.dateFinished, this.error, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkitemQueryJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    dateStarted: ").append(this.toIndentedString(this.dateStarted)).append("\n");
        sb.append("    dateFinished: ").append(this.toIndentedString(this.dateFinished)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("Queued"),
        RUNNING("Running"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

