/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.MessageInfo;
import com.mypurecloud.sdk.v2.model.PropertyChange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QualityAuditLogMessage
implements Serializable {
    private String id = null;
    private String userHomeOrgId = null;
    private String userTrusteeOrgId = null;
    private DomainEntityRef user = null;
    private AddressableEntityRef client = null;
    private List<String> remoteIps = null;
    private ServiceNameEnum serviceName = null;
    private LevelEnum level = null;
    private StatusEnum status = null;
    private Date eventDate = null;
    private MessageInfo messageInfo = null;
    private ActionEnum action = null;
    private DomainEntityRef entity = null;
    private EntityTypeEnum entityType = null;
    private List<PropertyChange> propertyChanges = null;
    private Map<String, String> context = null;

    public QualityAuditLogMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.remoteIps = new ArrayList<String>();
            this.propertyChanges = new ArrayList<PropertyChange>();
        }
    }

    public QualityAuditLogMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the audit message.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public QualityAuditLogMessage userHomeOrgId(String userHomeOrgId) {
        this.userHomeOrgId = userHomeOrgId;
        return this;
    }

    @ApiModelProperty(example="null", value="Home Organization Id associated with this audit message.")
    @JsonProperty(value="userHomeOrgId")
    public String getUserHomeOrgId() {
        return this.userHomeOrgId;
    }

    public void setUserHomeOrgId(String userHomeOrgId) {
        this.userHomeOrgId = userHomeOrgId;
    }

    public QualityAuditLogMessage userTrusteeOrgId(String userTrusteeOrgId) {
        this.userTrusteeOrgId = userTrusteeOrgId;
        return this;
    }

    @ApiModelProperty(example="null", value="Trustee Organization Id if this audit message is from trustee access.")
    @JsonProperty(value="userTrusteeOrgId")
    public String getUserTrusteeOrgId() {
        return this.userTrusteeOrgId;
    }

    public void setUserTrusteeOrgId(String userTrusteeOrgId) {
        this.userTrusteeOrgId = userTrusteeOrgId;
    }

    public QualityAuditLogMessage user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User associated with this audit message.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public QualityAuditLogMessage client(AddressableEntityRef client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(example="null", value="Client associated with this audit message.")
    @JsonProperty(value="client")
    public AddressableEntityRef getClient() {
        return this.client;
    }

    public void setClient(AddressableEntityRef client) {
        this.client = client;
    }

    public QualityAuditLogMessage remoteIps(List<String> remoteIps) {
        this.remoteIps = remoteIps;
        return this;
    }

    @ApiModelProperty(example="null", value="List of IP addresses of systems that originated or handled the request.")
    @JsonProperty(value="remoteIps")
    public List<String> getRemoteIps() {
        return this.remoteIps;
    }

    public void setRemoteIps(List<String> remoteIps) {
        this.remoteIps = remoteIps;
    }

    public QualityAuditLogMessage serviceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the service that logged this audit message.")
    @JsonProperty(value="serviceName")
    public ServiceNameEnum getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
    }

    public QualityAuditLogMessage level(LevelEnum level) {
        this.level = level;
        return this;
    }

    @ApiModelProperty(example="null", value="The level of this audit message.")
    @JsonProperty(value="level")
    public LevelEnum getLevel() {
        return this.level;
    }

    public void setLevel(LevelEnum level) {
        this.level = level;
    }

    public QualityAuditLogMessage status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the action of this audit message.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public QualityAuditLogMessage eventDate(Date eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDate")
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public QualityAuditLogMessage messageInfo(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
        return this;
    }

    @ApiModelProperty(example="null", value="Message describing the event being audited.")
    @JsonProperty(value="messageInfo")
    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public void setMessageInfo(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public QualityAuditLogMessage action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="Action that took place.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public QualityAuditLogMessage entity(DomainEntityRef entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="null", value="Entity that was impacted.")
    @JsonProperty(value="entity")
    public DomainEntityRef getEntity() {
        return this.entity;
    }

    public void setEntity(DomainEntityRef entity) {
        this.entity = entity;
    }

    public QualityAuditLogMessage entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the entity that was impacted.")
    @JsonProperty(value="entityType")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public QualityAuditLogMessage propertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
        return this;
    }

    @ApiModelProperty(example="null", value="List of properties that were changed and changes made to those properties.")
    @JsonProperty(value="propertyChanges")
    public List<PropertyChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void setPropertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
    }

    public QualityAuditLogMessage context(Map<String, String> context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional context for this message.")
    @JsonProperty(value="context")
    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualityAuditLogMessage qualityAuditLogMessage = (QualityAuditLogMessage)o;
        return Objects.equals(this.id, qualityAuditLogMessage.id) && Objects.equals(this.userHomeOrgId, qualityAuditLogMessage.userHomeOrgId) && Objects.equals(this.userTrusteeOrgId, qualityAuditLogMessage.userTrusteeOrgId) && Objects.equals(this.user, qualityAuditLogMessage.user) && Objects.equals(this.client, qualityAuditLogMessage.client) && Objects.equals(this.remoteIps, qualityAuditLogMessage.remoteIps) && Objects.equals((Object)this.serviceName, (Object)qualityAuditLogMessage.serviceName) && Objects.equals((Object)this.level, (Object)qualityAuditLogMessage.level) && Objects.equals((Object)this.status, (Object)qualityAuditLogMessage.status) && Objects.equals(this.eventDate, qualityAuditLogMessage.eventDate) && Objects.equals(this.messageInfo, qualityAuditLogMessage.messageInfo) && Objects.equals((Object)this.action, (Object)qualityAuditLogMessage.action) && Objects.equals(this.entity, qualityAuditLogMessage.entity) && Objects.equals((Object)this.entityType, (Object)qualityAuditLogMessage.entityType) && Objects.equals(this.propertyChanges, qualityAuditLogMessage.propertyChanges) && Objects.equals(this.context, qualityAuditLogMessage.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.userHomeOrgId, this.userTrusteeOrgId, this.user, this.client, this.remoteIps, this.serviceName, this.level, this.status, this.eventDate, this.messageInfo, this.action, this.entity, this.entityType, this.propertyChanges, this.context});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QualityAuditLogMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userHomeOrgId: ").append(this.toIndentedString(this.userHomeOrgId)).append("\n");
        sb.append("    userTrusteeOrgId: ").append(this.toIndentedString(this.userTrusteeOrgId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    remoteIps: ").append(this.toIndentedString(this.remoteIps)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString((Object)this.serviceName)).append("\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    messageInfo: ").append(this.toIndentedString(this.messageInfo)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    propertyChanges: ").append(this.toIndentedString(this.propertyChanges)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ServiceNameEnumDeserializer.class)
    public static enum ServiceNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RECORDINGSERVICE("RecordingService"),
        RECORDINGPLAYBACKSERVICE("RecordingPlaybackService"),
        QUALITYSERVICE("QualityService");

        private String value;

        private ServiceNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServiceNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServiceNameEnum value : ServiceNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServiceNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=LevelEnumDeserializer.class)
    public static enum LevelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        USER("User"),
        SYSTEM("System"),
        GENESYS_INTERNAL("GENESYS_INTERNAL");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LevelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LevelEnum value : LevelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LevelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESS("Success"),
        FAILURE("Failure"),
        WARNING("Warning");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        READ("Read"),
        CREATE("Create"),
        UPDATE("Update"),
        DELETE("Delete"),
        ABANDON("Abandon"),
        ARCHIVE("Archive"),
        EXPORT("Export"),
        DOWNLOAD("Download"),
        RESTOREREQUEST("RestoreRequest"),
        RESTORECOMPLETE("RestoreComplete"),
        APPLYPROTECTION("ApplyProtection"),
        REVOKEPROTECTION("RevokeProtection"),
        UPDATERETENTION("UpdateRetention");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=EntityTypeEnumDeserializer.class)
    public static enum EntityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RECORDING("Recording"),
        EVALUATION("Evaluation"),
        CALIBRATION("Calibration"),
        ANNOTATION("Annotation"),
        SCREENRECORDING("ScreenRecording"),
        SURVEY("Survey");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntityTypeEnum value : EntityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EntityTypeEnumDeserializer
    extends StdDeserializer<EntityTypeEnum> {
        public EntityTypeEnumDeserializer() {
            super(EntityTypeEnumDeserializer.class);
        }

        public EntityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EntityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class LevelEnumDeserializer
    extends StdDeserializer<LevelEnum> {
        public LevelEnumDeserializer() {
            super(LevelEnumDeserializer.class);
        }

        public LevelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LevelEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ServiceNameEnumDeserializer
    extends StdDeserializer<ServiceNameEnum> {
        public ServiceNameEnumDeserializer() {
            super(ServiceNameEnumDeserializer.class);
        }

        public ServiceNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ServiceNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

