/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.LocationAddress;
import com.mypurecloud.sdk.v2.model.LocationEmergencyNumber;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class LocationUpdateDefinition
implements Serializable {
    private String name = null;
    private Integer version = null;
    private StateEnum state = null;
    private List<String> path = null;
    private String notes = null;
    private String contactUser = null;
    private LocationEmergencyNumber emergencyNumber = null;
    private LocationAddress address = null;

    public LocationUpdateDefinition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.path = new ArrayList<String>();
        }
    }

    public LocationUpdateDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Location. Required for creates, not required for updates")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocationUpdateDefinition version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Current version of the location")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public LocationUpdateDefinition state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Current activity status of the location.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LocationUpdateDefinition path(List<String> path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of ancestor ids")
    @JsonProperty(value="path")
    public List<String> getPath() {
        return this.path;
    }

    public void setPath(List<String> path) {
        this.path = path;
    }

    public LocationUpdateDefinition notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes for the location")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public LocationUpdateDefinition contactUser(String contactUser) {
        this.contactUser = contactUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user id of the location contact")
    @JsonProperty(value="contactUser")
    public String getContactUser() {
        return this.contactUser;
    }

    public void setContactUser(String contactUser) {
        this.contactUser = contactUser;
    }

    public LocationUpdateDefinition emergencyNumber(LocationEmergencyNumber emergencyNumber) {
        this.emergencyNumber = emergencyNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Emergency number for the location")
    @JsonProperty(value="emergencyNumber")
    public LocationEmergencyNumber getEmergencyNumber() {
        return this.emergencyNumber;
    }

    public void setEmergencyNumber(LocationEmergencyNumber emergencyNumber) {
        this.emergencyNumber = emergencyNumber;
    }

    public LocationUpdateDefinition address(LocationAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(example="null", value="Address of the location")
    @JsonProperty(value="address")
    public LocationAddress getAddress() {
        return this.address;
    }

    public void setAddress(LocationAddress address) {
        this.address = address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationUpdateDefinition locationUpdateDefinition = (LocationUpdateDefinition)o;
        return Objects.equals(this.name, locationUpdateDefinition.name) && Objects.equals(this.version, locationUpdateDefinition.version) && Objects.equals((Object)this.state, (Object)locationUpdateDefinition.state) && Objects.equals(this.path, locationUpdateDefinition.path) && Objects.equals(this.notes, locationUpdateDefinition.notes) && Objects.equals(this.contactUser, locationUpdateDefinition.contactUser) && Objects.equals(this.emergencyNumber, locationUpdateDefinition.emergencyNumber) && Objects.equals(this.address, locationUpdateDefinition.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.version, this.state, this.path, this.notes, this.contactUser, this.emergencyNumber, this.address});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocationUpdateDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    contactUser: ").append(this.toIndentedString(this.contactUser)).append("\n");
        sb.append("    emergencyNumber: ").append(this.toIndentedString(this.emergencyNumber)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

