/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class AssessmentQuestionScore
implements Serializable {
    private Boolean failedKillQuestion = null;
    private String comments = null;
    private String questionId = null;
    private String answerId = null;
    private Integer score = null;
    private Boolean markedNA = null;
    private Boolean systemMarkedNA = null;
    private String freeTextAnswer = null;

    public AssessmentQuestionScore() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="True if this was a failed Kill question")
    @JsonProperty(value="failedKillQuestion")
    public Boolean getFailedKillQuestion() {
        return this.failedKillQuestion;
    }

    public AssessmentQuestionScore comments(String comments) {
        this.comments = comments;
        return this;
    }

    @ApiModelProperty(example="null", value="Comments provided for the answer")
    @JsonProperty(value="comments")
    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public AssessmentQuestionScore questionId(String questionId) {
        this.questionId = questionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the question")
    @JsonProperty(value="questionId")
    public String getQuestionId() {
        return this.questionId;
    }

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public AssessmentQuestionScore answerId(String answerId) {
        this.answerId = answerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the selected answer")
    @JsonProperty(value="answerId")
    public String getAnswerId() {
        return this.answerId;
    }

    public void setAnswerId(String answerId) {
        this.answerId = answerId;
    }

    @ApiModelProperty(example="null", value="The score received for this question")
    @JsonProperty(value="score")
    public Integer getScore() {
        return this.score;
    }

    public AssessmentQuestionScore markedNA(Boolean markedNA) {
        this.markedNA = markedNA;
        return this;
    }

    @ApiModelProperty(example="null", value="True if this question was marked as NA")
    @JsonProperty(value="markedNA")
    public Boolean getMarkedNA() {
        return this.markedNA;
    }

    public void setMarkedNA(Boolean markedNA) {
        this.markedNA = markedNA;
    }

    public AssessmentQuestionScore systemMarkedNA(Boolean systemMarkedNA) {
        this.systemMarkedNA = systemMarkedNA;
        return this;
    }

    @ApiModelProperty(example="null", value="If markedNA is true, systemMarkedNA indicates whether it was marked by a user or by the system due to visibility conditions. Always false if markedNA is false.")
    @JsonProperty(value="systemMarkedNA")
    public Boolean getSystemMarkedNA() {
        return this.systemMarkedNA;
    }

    public void setSystemMarkedNA(Boolean systemMarkedNA) {
        this.systemMarkedNA = systemMarkedNA;
    }

    public AssessmentQuestionScore freeTextAnswer(String freeTextAnswer) {
        this.freeTextAnswer = freeTextAnswer;
        return this;
    }

    @ApiModelProperty(example="null", value="Answer for free text answer type")
    @JsonProperty(value="freeTextAnswer")
    public String getFreeTextAnswer() {
        return this.freeTextAnswer;
    }

    public void setFreeTextAnswer(String freeTextAnswer) {
        this.freeTextAnswer = freeTextAnswer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssessmentQuestionScore assessmentQuestionScore = (AssessmentQuestionScore)o;
        return Objects.equals(this.failedKillQuestion, assessmentQuestionScore.failedKillQuestion) && Objects.equals(this.comments, assessmentQuestionScore.comments) && Objects.equals(this.questionId, assessmentQuestionScore.questionId) && Objects.equals(this.answerId, assessmentQuestionScore.answerId) && Objects.equals(this.score, assessmentQuestionScore.score) && Objects.equals(this.markedNA, assessmentQuestionScore.markedNA) && Objects.equals(this.systemMarkedNA, assessmentQuestionScore.systemMarkedNA) && Objects.equals(this.freeTextAnswer, assessmentQuestionScore.freeTextAnswer);
    }

    public int hashCode() {
        return Objects.hash(this.failedKillQuestion, this.comments, this.questionId, this.answerId, this.score, this.markedNA, this.systemMarkedNA, this.freeTextAnswer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssessmentQuestionScore {\n");
        sb.append("    failedKillQuestion: ").append(this.toIndentedString(this.failedKillQuestion)).append("\n");
        sb.append("    comments: ").append(this.toIndentedString(this.comments)).append("\n");
        sb.append("    questionId: ").append(this.toIndentedString(this.questionId)).append("\n");
        sb.append("    answerId: ").append(this.toIndentedString(this.answerId)).append("\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    markedNA: ").append(this.toIndentedString(this.markedNA)).append("\n");
        sb.append("    systemMarkedNA: ").append(this.toIndentedString(this.systemMarkedNA)).append("\n");
        sb.append("    freeTextAnswer: ").append(this.toIndentedString(this.freeTextAnswer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

