/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteAlertingAlertRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteAlertingAlertsAllRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteAlertingRuleRequest;
import com.mypurecloud.sdk.v2.api.request.GetAlertingAlertRequest;
import com.mypurecloud.sdk.v2.api.request.GetAlertingRuleRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAlertingAlertRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAlertingAlertsAllRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAlertingAlertsBulkRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAlertingRulesBulkRequest;
import com.mypurecloud.sdk.v2.api.request.PostAlertingAlertsQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostAlertingRulesBulkRemoveRequest;
import com.mypurecloud.sdk.v2.api.request.PostAlertingRulesQueryRequest;
import com.mypurecloud.sdk.v2.api.request.PostAlertingRulesRequest;
import com.mypurecloud.sdk.v2.api.request.PutAlertingAlertRequest;
import com.mypurecloud.sdk.v2.api.request.PutAlertingRuleRequest;
import com.mypurecloud.sdk.v2.model.AlertListing;
import com.mypurecloud.sdk.v2.model.AlertRequest;
import com.mypurecloud.sdk.v2.model.AlertingUnreadStatus;
import com.mypurecloud.sdk.v2.model.BulkResponse;
import com.mypurecloud.sdk.v2.model.CommonAlert;
import com.mypurecloud.sdk.v2.model.CommonAlertBulkUpdateRequest;
import com.mypurecloud.sdk.v2.model.CommonAllAlertUpdateRequest;
import com.mypurecloud.sdk.v2.model.CommonRule;
import com.mypurecloud.sdk.v2.model.CommonRuleBulkDeleteRequest;
import com.mypurecloud.sdk.v2.model.CommonRuleBulkUpdateNotificationsRequest;
import com.mypurecloud.sdk.v2.model.CommonRuleContainer;
import com.mypurecloud.sdk.v2.model.Empty;
import com.mypurecloud.sdk.v2.model.GetAlertQuery;
import com.mypurecloud.sdk.v2.model.GetRulesQuery;
import com.mypurecloud.sdk.v2.model.ModifiableRuleProperties;
import java.io.IOException;

public class AlertingApi {
    private final ApiClient pcapiClient;

    public AlertingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlertingApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAlertingAlert(String alertId) throws IOException, ApiException {
        this.deleteAlertingAlert(this.createDeleteAlertingAlertRequest(alertId));
    }

    public ApiResponse<Void> deleteAlertingAlertWithHttpInfo(String alertId) throws IOException {
        return this.deleteAlertingAlert(this.createDeleteAlertingAlertRequest(alertId).withHttpInfo());
    }

    private DeleteAlertingAlertRequest createDeleteAlertingAlertRequest(String alertId) {
        return DeleteAlertingAlertRequest.builder().withAlertId(alertId).build();
    }

    public void deleteAlertingAlert(DeleteAlertingAlertRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAlertingAlert(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Empty deleteAlertingAlertsAll() throws IOException, ApiException {
        return this.deleteAlertingAlertsAll(this.createDeleteAlertingAlertsAllRequest());
    }

    public ApiResponse<Empty> deleteAlertingAlertsAllWithHttpInfo() throws IOException {
        return this.deleteAlertingAlertsAll(this.createDeleteAlertingAlertsAllRequest().withHttpInfo());
    }

    private DeleteAlertingAlertsAllRequest createDeleteAlertingAlertsAllRequest() {
        return DeleteAlertingAlertsAllRequest.builder().build();
    }

    public Empty deleteAlertingAlertsAll(DeleteAlertingAlertsAllRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Empty> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Empty>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Empty> deleteAlertingAlertsAll(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Empty>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteAlertingRule(String ruleId) throws IOException, ApiException {
        this.deleteAlertingRule(this.createDeleteAlertingRuleRequest(ruleId));
    }

    public ApiResponse<Void> deleteAlertingRuleWithHttpInfo(String ruleId) throws IOException {
        return this.deleteAlertingRule(this.createDeleteAlertingRuleRequest(ruleId).withHttpInfo());
    }

    private DeleteAlertingRuleRequest createDeleteAlertingRuleRequest(String ruleId) {
        return DeleteAlertingRuleRequest.builder().withRuleId(ruleId).build();
    }

    public void deleteAlertingRule(DeleteAlertingRuleRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteAlertingRule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CommonAlert getAlertingAlert(String alertId) throws IOException, ApiException {
        return this.getAlertingAlert(this.createGetAlertingAlertRequest(alertId));
    }

    public ApiResponse<CommonAlert> getAlertingAlertWithHttpInfo(String alertId) throws IOException {
        return this.getAlertingAlert(this.createGetAlertingAlertRequest(alertId).withHttpInfo());
    }

    private GetAlertingAlertRequest createGetAlertingAlertRequest(String alertId) {
        return GetAlertingAlertRequest.builder().withAlertId(alertId).build();
    }

    public CommonAlert getAlertingAlert(GetAlertingAlertRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CommonAlert> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CommonAlert>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CommonAlert> getAlertingAlert(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CommonAlert>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CommonRule getAlertingRule(String ruleId) throws IOException, ApiException {
        return this.getAlertingRule(this.createGetAlertingRuleRequest(ruleId));
    }

    public ApiResponse<CommonRule> getAlertingRuleWithHttpInfo(String ruleId) throws IOException {
        return this.getAlertingRule(this.createGetAlertingRuleRequest(ruleId).withHttpInfo());
    }

    private GetAlertingRuleRequest createGetAlertingRuleRequest(String ruleId) {
        return GetAlertingRuleRequest.builder().withRuleId(ruleId).build();
    }

    public CommonRule getAlertingRule(GetAlertingRuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CommonRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CommonRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CommonRule> getAlertingRule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CommonRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CommonAlert patchAlertingAlert(String alertId, AlertRequest body) throws IOException, ApiException {
        return this.patchAlertingAlert(this.createPatchAlertingAlertRequest(alertId, body));
    }

    public ApiResponse<CommonAlert> patchAlertingAlertWithHttpInfo(String alertId, AlertRequest body) throws IOException {
        return this.patchAlertingAlert(this.createPatchAlertingAlertRequest(alertId, body).withHttpInfo());
    }

    private PatchAlertingAlertRequest createPatchAlertingAlertRequest(String alertId, AlertRequest body) {
        return PatchAlertingAlertRequest.builder().withAlertId(alertId).withBody(body).build();
    }

    public CommonAlert patchAlertingAlert(PatchAlertingAlertRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CommonAlert> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CommonAlert>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CommonAlert> patchAlertingAlert(ApiRequest<AlertRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CommonAlert>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Empty patchAlertingAlertsAll(CommonAllAlertUpdateRequest body) throws IOException, ApiException {
        return this.patchAlertingAlertsAll(this.createPatchAlertingAlertsAllRequest(body));
    }

    public ApiResponse<Empty> patchAlertingAlertsAllWithHttpInfo(CommonAllAlertUpdateRequest body) throws IOException {
        return this.patchAlertingAlertsAll(this.createPatchAlertingAlertsAllRequest(body).withHttpInfo());
    }

    private PatchAlertingAlertsAllRequest createPatchAlertingAlertsAllRequest(CommonAllAlertUpdateRequest body) {
        return PatchAlertingAlertsAllRequest.builder().withBody(body).build();
    }

    public Empty patchAlertingAlertsAll(PatchAlertingAlertsAllRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Empty> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Empty>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Empty> patchAlertingAlertsAll(ApiRequest<CommonAllAlertUpdateRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Empty>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BulkResponse patchAlertingAlertsBulk(CommonAlertBulkUpdateRequest body) throws IOException, ApiException {
        return this.patchAlertingAlertsBulk(this.createPatchAlertingAlertsBulkRequest(body));
    }

    public ApiResponse<BulkResponse> patchAlertingAlertsBulkWithHttpInfo(CommonAlertBulkUpdateRequest body) throws IOException {
        return this.patchAlertingAlertsBulk(this.createPatchAlertingAlertsBulkRequest(body).withHttpInfo());
    }

    private PatchAlertingAlertsBulkRequest createPatchAlertingAlertsBulkRequest(CommonAlertBulkUpdateRequest body) {
        return PatchAlertingAlertsBulkRequest.builder().withBody(body).build();
    }

    public BulkResponse patchAlertingAlertsBulk(PatchAlertingAlertsBulkRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BulkResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BulkResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BulkResponse> patchAlertingAlertsBulk(ApiRequest<CommonAlertBulkUpdateRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BulkResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BulkResponse patchAlertingRulesBulk(CommonRuleBulkUpdateNotificationsRequest body) throws IOException, ApiException {
        return this.patchAlertingRulesBulk(this.createPatchAlertingRulesBulkRequest(body));
    }

    public ApiResponse<BulkResponse> patchAlertingRulesBulkWithHttpInfo(CommonRuleBulkUpdateNotificationsRequest body) throws IOException {
        return this.patchAlertingRulesBulk(this.createPatchAlertingRulesBulkRequest(body).withHttpInfo());
    }

    private PatchAlertingRulesBulkRequest createPatchAlertingRulesBulkRequest(CommonRuleBulkUpdateNotificationsRequest body) {
        return PatchAlertingRulesBulkRequest.builder().withBody(body).build();
    }

    public BulkResponse patchAlertingRulesBulk(PatchAlertingRulesBulkRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BulkResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BulkResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BulkResponse> patchAlertingRulesBulk(ApiRequest<CommonRuleBulkUpdateNotificationsRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BulkResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AlertListing postAlertingAlertsQuery(GetAlertQuery body) throws IOException, ApiException {
        return this.postAlertingAlertsQuery(this.createPostAlertingAlertsQueryRequest(body));
    }

    public ApiResponse<AlertListing> postAlertingAlertsQueryWithHttpInfo(GetAlertQuery body) throws IOException {
        return this.postAlertingAlertsQuery(this.createPostAlertingAlertsQueryRequest(body).withHttpInfo());
    }

    private PostAlertingAlertsQueryRequest createPostAlertingAlertsQueryRequest(GetAlertQuery body) {
        return PostAlertingAlertsQueryRequest.builder().withBody(body).build();
    }

    public AlertListing postAlertingAlertsQuery(PostAlertingAlertsQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AlertListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AlertListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AlertListing> postAlertingAlertsQuery(ApiRequest<GetAlertQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AlertListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CommonRule postAlertingRules(CommonRule body) throws IOException, ApiException {
        return this.postAlertingRules(this.createPostAlertingRulesRequest(body));
    }

    public ApiResponse<CommonRule> postAlertingRulesWithHttpInfo(CommonRule body) throws IOException {
        return this.postAlertingRules(this.createPostAlertingRulesRequest(body).withHttpInfo());
    }

    private PostAlertingRulesRequest createPostAlertingRulesRequest(CommonRule body) {
        return PostAlertingRulesRequest.builder().withBody(body).build();
    }

    public CommonRule postAlertingRules(PostAlertingRulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CommonRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CommonRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CommonRule> postAlertingRules(ApiRequest<CommonRule> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CommonRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public BulkResponse postAlertingRulesBulkRemove(CommonRuleBulkDeleteRequest body) throws IOException, ApiException {
        return this.postAlertingRulesBulkRemove(this.createPostAlertingRulesBulkRemoveRequest(body));
    }

    public ApiResponse<BulkResponse> postAlertingRulesBulkRemoveWithHttpInfo(CommonRuleBulkDeleteRequest body) throws IOException {
        return this.postAlertingRulesBulkRemove(this.createPostAlertingRulesBulkRemoveRequest(body).withHttpInfo());
    }

    private PostAlertingRulesBulkRemoveRequest createPostAlertingRulesBulkRemoveRequest(CommonRuleBulkDeleteRequest body) {
        return PostAlertingRulesBulkRemoveRequest.builder().withBody(body).build();
    }

    public BulkResponse postAlertingRulesBulkRemove(PostAlertingRulesBulkRemoveRequest request) throws IOException, ApiException {
        try {
            ApiResponse<BulkResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<BulkResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<BulkResponse> postAlertingRulesBulkRemove(ApiRequest<CommonRuleBulkDeleteRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<BulkResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CommonRuleContainer postAlertingRulesQuery(GetRulesQuery body) throws IOException, ApiException {
        return this.postAlertingRulesQuery(this.createPostAlertingRulesQueryRequest(body));
    }

    public ApiResponse<CommonRuleContainer> postAlertingRulesQueryWithHttpInfo(GetRulesQuery body) throws IOException {
        return this.postAlertingRulesQuery(this.createPostAlertingRulesQueryRequest(body).withHttpInfo());
    }

    private PostAlertingRulesQueryRequest createPostAlertingRulesQueryRequest(GetRulesQuery body) {
        return PostAlertingRulesQueryRequest.builder().withBody(body).build();
    }

    public CommonRuleContainer postAlertingRulesQuery(PostAlertingRulesQueryRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CommonRuleContainer> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CommonRuleContainer>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CommonRuleContainer> postAlertingRulesQuery(ApiRequest<GetRulesQuery> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CommonRuleContainer>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AlertingUnreadStatus putAlertingAlert(String alertId, AlertingUnreadStatus body) throws IOException, ApiException {
        return this.putAlertingAlert(this.createPutAlertingAlertRequest(alertId, body));
    }

    public ApiResponse<AlertingUnreadStatus> putAlertingAlertWithHttpInfo(String alertId, AlertingUnreadStatus body) throws IOException {
        return this.putAlertingAlert(this.createPutAlertingAlertRequest(alertId, body).withHttpInfo());
    }

    private PutAlertingAlertRequest createPutAlertingAlertRequest(String alertId, AlertingUnreadStatus body) {
        return PutAlertingAlertRequest.builder().withAlertId(alertId).withBody(body).build();
    }

    public AlertingUnreadStatus putAlertingAlert(PutAlertingAlertRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AlertingUnreadStatus> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AlertingUnreadStatus>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AlertingUnreadStatus> putAlertingAlert(ApiRequest<AlertingUnreadStatus> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AlertingUnreadStatus>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CommonRule putAlertingRule(String ruleId, ModifiableRuleProperties body) throws IOException, ApiException {
        return this.putAlertingRule(this.createPutAlertingRuleRequest(ruleId, body));
    }

    public ApiResponse<CommonRule> putAlertingRuleWithHttpInfo(String ruleId, ModifiableRuleProperties body) throws IOException {
        return this.putAlertingRule(this.createPutAlertingRuleRequest(ruleId, body).withHttpInfo());
    }

    private PutAlertingRuleRequest createPutAlertingRuleRequest(String ruleId, ModifiableRuleProperties body) {
        return PutAlertingRuleRequest.builder().withRuleId(ruleId).withBody(body).build();
    }

    public CommonRule putAlertingRule(PutAlertingRuleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CommonRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CommonRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CommonRule> putAlertingRule(ApiRequest<ModifiableRuleProperties> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CommonRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

