/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.TextBotFlowMilestone;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Flow Outcome data related to a bot flow which is exiting gracefully.")
public class TextBotFlowOutcome
implements Serializable {
    private String outcomeId = null;
    private OutcomeValueEnum outcomeValue = null;
    private Date dateStart = null;
    private Date dateEnd = null;
    private List<TextBotFlowMilestone> milestones = null;

    public TextBotFlowOutcome() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.milestones = new ArrayList<TextBotFlowMilestone>();
        }
    }

    public TextBotFlowOutcome outcomeId(String outcomeId) {
        this.outcomeId = outcomeId;
        return this;
    }

    @ApiModelProperty(example="null", value="The Flow Outcome ID.")
    @JsonProperty(value="outcomeId")
    public String getOutcomeId() {
        return this.outcomeId;
    }

    public void setOutcomeId(String outcomeId) {
        this.outcomeId = outcomeId;
    }

    public TextBotFlowOutcome outcomeValue(OutcomeValueEnum outcomeValue) {
        this.outcomeValue = outcomeValue;
        return this;
    }

    @ApiModelProperty(example="null", value="The value of the FlowOutcome.")
    @JsonProperty(value="outcomeValue")
    public OutcomeValueEnum getOutcomeValue() {
        return this.outcomeValue;
    }

    public void setOutcomeValue(OutcomeValueEnum outcomeValue) {
        this.outcomeValue = outcomeValue;
    }

    public TextBotFlowOutcome dateStart(Date dateStart) {
        this.dateStart = dateStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp for when the Flow Outcome began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateStart")
    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public TextBotFlowOutcome dateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp for when the Flow Outcome finished. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateEnd")
    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public TextBotFlowOutcome milestones(List<TextBotFlowMilestone> milestones) {
        this.milestones = milestones;
        return this;
    }

    @ApiModelProperty(example="null", value="The Flow Milestones for the Flow Outcome.")
    @JsonProperty(value="milestones")
    public List<TextBotFlowMilestone> getMilestones() {
        return this.milestones;
    }

    public void setMilestones(List<TextBotFlowMilestone> milestones) {
        this.milestones = milestones;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotFlowOutcome textBotFlowOutcome = (TextBotFlowOutcome)o;
        return Objects.equals(this.outcomeId, textBotFlowOutcome.outcomeId) && Objects.equals((Object)this.outcomeValue, (Object)textBotFlowOutcome.outcomeValue) && Objects.equals(this.dateStart, textBotFlowOutcome.dateStart) && Objects.equals(this.dateEnd, textBotFlowOutcome.dateEnd) && Objects.equals(this.milestones, textBotFlowOutcome.milestones);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outcomeId, this.outcomeValue, this.dateStart, this.dateEnd, this.milestones});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotFlowOutcome {\n");
        sb.append("    outcomeId: ").append(this.toIndentedString(this.outcomeId)).append("\n");
        sb.append("    outcomeValue: ").append(this.toIndentedString((Object)this.outcomeValue)).append("\n");
        sb.append("    dateStart: ").append(this.toIndentedString(this.dateStart)).append("\n");
        sb.append("    dateEnd: ").append(this.toIndentedString(this.dateEnd)).append("\n");
        sb.append("    milestones: ").append(this.toIndentedString(this.milestones)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OutcomeValueEnumDeserializer.class)
    public static enum OutcomeValueEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE");

        private String value;

        private OutcomeValueEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OutcomeValueEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OutcomeValueEnum value : OutcomeValueEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OutcomeValueEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OutcomeValueEnumDeserializer
    extends StdDeserializer<OutcomeValueEnum> {
        public OutcomeValueEnumDeserializer() {
            super(OutcomeValueEnumDeserializer.class);
        }

        public OutcomeValueEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OutcomeValueEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

