/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Defines response components of the Action Request.")
public class ResponseConfig
implements Serializable {
    private Map<String, String> translationMap = null;
    private Map<String, String> translationMapDefaults = null;
    private String successTemplate = null;
    private String successTemplateUri = null;

    public ResponseConfig() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ResponseConfig translationMap(Map<String, String> translationMap) {
        this.translationMap = translationMap;
        return this;
    }

    @ApiModelProperty(example="null", value="Map 'attribute name' and 'JSON path' pairs used to extract data from REST response.")
    @JsonProperty(value="translationMap")
    public Map<String, String> getTranslationMap() {
        return this.translationMap;
    }

    public void setTranslationMap(Map<String, String> translationMap) {
        this.translationMap = translationMap;
    }

    public ResponseConfig translationMapDefaults(Map<String, String> translationMapDefaults) {
        this.translationMapDefaults = translationMapDefaults;
        return this;
    }

    @ApiModelProperty(example="null", value="Map 'attribute name' and 'default value' pairs used as fallback values if JSON path extraction fails for specified key.")
    @JsonProperty(value="translationMapDefaults")
    public Map<String, String> getTranslationMapDefaults() {
        return this.translationMapDefaults;
    }

    public void setTranslationMapDefaults(Map<String, String> translationMapDefaults) {
        this.translationMapDefaults = translationMapDefaults;
    }

    public ResponseConfig successTemplate(String successTemplate) {
        this.successTemplate = successTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="Velocity template to build response to return from Action.")
    @JsonProperty(value="successTemplate")
    public String getSuccessTemplate() {
        return this.successTemplate;
    }

    public void setSuccessTemplate(String successTemplate) {
        this.successTemplate = successTemplate;
    }

    public ResponseConfig successTemplateUri(String successTemplateUri) {
        this.successTemplateUri = successTemplateUri;
        return this;
    }

    @ApiModelProperty(example="null", value="URI to retrieve success template.")
    @JsonProperty(value="successTemplateUri")
    public String getSuccessTemplateUri() {
        return this.successTemplateUri;
    }

    public void setSuccessTemplateUri(String successTemplateUri) {
        this.successTemplateUri = successTemplateUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseConfig responseConfig = (ResponseConfig)o;
        return Objects.equals(this.translationMap, responseConfig.translationMap) && Objects.equals(this.translationMapDefaults, responseConfig.translationMapDefaults) && Objects.equals(this.successTemplate, responseConfig.successTemplate) && Objects.equals(this.successTemplateUri, responseConfig.successTemplateUri);
    }

    public int hashCode() {
        return Objects.hash(this.translationMap, this.translationMapDefaults, this.successTemplate, this.successTemplateUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseConfig {\n");
        sb.append("    translationMap: ").append(this.toIndentedString(this.translationMap)).append("\n");
        sb.append("    translationMapDefaults: ").append(this.toIndentedString(this.translationMapDefaults)).append("\n");
        sb.append("    successTemplate: ").append(this.toIndentedString(this.successTemplate)).append("\n");
        sb.append("    successTemplateUri: ").append(this.toIndentedString(this.successTemplateUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

