/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Pattern
implements Serializable {
    private TypeEnum type = null;
    private Integer interval = null;
    private List<DaysOfWeekEnum> daysOfWeek = null;

    public Pattern() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.daysOfWeek = new ArrayList<DaysOfWeekEnum>();
        }
    }

    public Pattern type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Pattern type (Daily/Weekly)")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Pattern interval(Integer interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The interval of days between the occurrences for Daily pattern type, and weeks between the occurrences for Weekly")
    @JsonProperty(value="interval")
    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public Pattern daysOfWeek(List<DaysOfWeekEnum> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
        return this;
    }

    @ApiModelProperty(example="null", value="The day(s) of week the occurrence should be repeated. Required to set for Weekly pattern type. E.g. [\"Monday\", \"Wednesday\"]")
    @JsonProperty(value="daysOfWeek")
    public List<DaysOfWeekEnum> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfWeek(List<DaysOfWeekEnum> daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pattern pattern = (Pattern)o;
        return Objects.equals((Object)this.type, (Object)pattern.type) && Objects.equals(this.interval, pattern.interval) && Objects.equals(this.daysOfWeek, pattern.daysOfWeek);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.interval, this.daysOfWeek});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pattern {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    daysOfWeek: ").append(this.toIndentedString(this.daysOfWeek)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DAILY("Daily"),
        WEEKLY("Weekly");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=DaysOfWeekEnumDeserializer.class)
    public static enum DaysOfWeekEnum {
        SUNDAY("Sunday"),
        MONDAY("Monday"),
        TUESDAY("Tuesday"),
        WEDNESDAY("Wednesday"),
        THURSDAY("Thursday"),
        FRIDAY("Friday"),
        SATURDAY("Saturday");

        private String value;

        private DaysOfWeekEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DaysOfWeekEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DaysOfWeekEnum value : DaysOfWeekEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DaysOfWeekEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DaysOfWeekEnumDeserializer
    extends StdDeserializer<DaysOfWeekEnum> {
        public DaysOfWeekEnumDeserializer() {
            super(DaysOfWeekEnumDeserializer.class);
        }

        public DaysOfWeekEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DaysOfWeekEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

