/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RoomUpdateRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchChatsRoomRequest {
    private String roomJid;
    private RoomUpdateRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public PatchChatsRoomRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public RoomUpdateRequest getBody() {
        return this.body;
    }

    public void setBody(RoomUpdateRequest body) {
        this.body = body;
    }

    public PatchChatsRoomRequest withBody(RoomUpdateRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchChatsRoomRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RoomUpdateRequest> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PatchChatsRoomRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchChatsRoomRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/chats/rooms/{roomJid}").withPathParameter("roomJid", this.roomJid).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, RoomUpdateRequest body) {
        return new Builder().withRequiredParams(roomJid, body);
    }

    public static class Builder {
        private final PatchChatsRoomRequest request = new PatchChatsRoomRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withBody(RoomUpdateRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roomJid, RoomUpdateRequest body) {
            this.request.setRoomJid(roomJid);
            this.request.setBody(body);
            return this;
        }

        public PatchChatsRoomRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PatchChatsRoomRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchChatsRoomRequest.");
            }
            return this.request;
        }
    }
}

