/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines a simple matching condition")
public class MatchCriteria
implements Serializable {
    private String jsonPath = null;
    private OperatorEnum operator = null;
    private JsonNode value = null;
    private List<JsonNode> values = null;

    public MatchCriteria() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.values = new ArrayList<JsonNode>();
        }
    }

    public MatchCriteria jsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
        return this;
    }

    @ApiModelProperty(example="null", value="The Goessner json path of the field to match")
    @JsonProperty(value="jsonPath")
    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public MatchCriteria operator(OperatorEnum operator) {
        this.operator = operator;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of operation to perform for matching check")
    @JsonProperty(value="operator")
    public OperatorEnum getOperator() {
        return this.operator;
    }

    public void setOperator(OperatorEnum operator) {
        this.operator = operator;
    }

    public MatchCriteria value(JsonNode value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="The value to match on. Only one of value and values can be included")
    @JsonProperty(value="value")
    public JsonNode getValue() {
        return this.value;
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    public MatchCriteria values(List<JsonNode> values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of values to match on. Only one of value and values can be included")
    @JsonProperty(value="values")
    public List<JsonNode> getValues() {
        return this.values;
    }

    public void setValues(List<JsonNode> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchCriteria matchCriteria = (MatchCriteria)o;
        return Objects.equals(this.jsonPath, matchCriteria.jsonPath) && Objects.equals((Object)this.operator, (Object)matchCriteria.operator) && Objects.equals(this.value, matchCriteria.value) && Objects.equals(this.values, matchCriteria.values);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonPath, this.operator, this.value, this.values});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchCriteria {\n");
        sb.append("    jsonPath: ").append(this.toIndentedString(this.jsonPath)).append("\n");
        sb.append("    operator: ").append(this.toIndentedString((Object)this.operator)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperatorEnumDeserializer.class)
    public static enum OperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GREATERTHANOREQUAL("GreaterThanOrEqual"),
        LESSTHANOREQUAL("LessThanOrEqual"),
        EQUAL("Equal"),
        NOTEQUAL("NotEqual"),
        LESSTHAN("LessThan"),
        GREATERTHAN("GreaterThan"),
        NOTIN("NotIn"),
        IN("In"),
        CONTAINS("Contains"),
        ALL("All"),
        EXISTS("Exists"),
        SIZE("Size");

        private String value;

        private OperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperatorEnum value : OperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperatorEnumDeserializer
    extends StdDeserializer<OperatorEnum> {
        public OperatorEnumDeserializer() {
            super(OperatorEnumDeserializer.class);
        }

        public OperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

