/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.RequestContext;
import com.mypurecloud.sdk.v2.model.RequestExternalSegment;
import com.mypurecloud.sdk.v2.model.RequestJourney;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class JourneySegmentRequest
implements Serializable {
    private Boolean isActive = null;
    private String displayName = null;
    private Integer version = null;
    private String description = null;
    private String color = null;
    private ScopeEnum scope = null;
    private Boolean shouldDisplayToAgent = null;
    private RequestContext context = null;
    private RequestJourney journey = null;
    private RequestExternalSegment externalSegment = null;
    private Integer assignmentExpirationDays = null;

    public JourneySegmentRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public JourneySegmentRequest isActive(Boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not the segment is active.")
    @JsonProperty(value="isActive")
    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public JourneySegmentRequest displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The display name of the segment.")
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public JourneySegmentRequest version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The version of the segment.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public JourneySegmentRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="A description of the segment.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public JourneySegmentRequest color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The hexadecimal color value of the segment.")
    @JsonProperty(value="color")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public JourneySegmentRequest scope(ScopeEnum scope) {
        this.scope = scope;
        return this;
    }

    @ApiModelProperty(example="null", value="The target entity that a segment applies to.")
    @JsonProperty(value="scope")
    public ScopeEnum getScope() {
        return this.scope;
    }

    public void setScope(ScopeEnum scope) {
        this.scope = scope;
    }

    public JourneySegmentRequest shouldDisplayToAgent(Boolean shouldDisplayToAgent) {
        this.shouldDisplayToAgent = shouldDisplayToAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether or not the segment should be displayed to agent/supervisor users.")
    @JsonProperty(value="shouldDisplayToAgent")
    public Boolean getShouldDisplayToAgent() {
        return this.shouldDisplayToAgent;
    }

    public void setShouldDisplayToAgent(Boolean shouldDisplayToAgent) {
        this.shouldDisplayToAgent = shouldDisplayToAgent;
    }

    public JourneySegmentRequest context(RequestContext context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The context of the segment.")
    @JsonProperty(value="context")
    public RequestContext getContext() {
        return this.context;
    }

    public void setContext(RequestContext context) {
        this.context = context;
    }

    public JourneySegmentRequest journey(RequestJourney journey) {
        this.journey = journey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The pattern of rules defining the segment.")
    @JsonProperty(value="journey")
    public RequestJourney getJourney() {
        return this.journey;
    }

    public void setJourney(RequestJourney journey) {
        this.journey = journey;
    }

    public JourneySegmentRequest externalSegment(RequestExternalSegment externalSegment) {
        this.externalSegment = externalSegment;
        return this;
    }

    @ApiModelProperty(example="null", value="Details of an entity corresponding to this segment in an external system.")
    @JsonProperty(value="externalSegment")
    public RequestExternalSegment getExternalSegment() {
        return this.externalSegment;
    }

    public void setExternalSegment(RequestExternalSegment externalSegment) {
        this.externalSegment = externalSegment;
    }

    public JourneySegmentRequest assignmentExpirationDays(Integer assignmentExpirationDays) {
        this.assignmentExpirationDays = assignmentExpirationDays;
        return this;
    }

    @ApiModelProperty(example="null", value="Time, in days, from when the segment is assigned until it is automatically unassigned.")
    @JsonProperty(value="assignmentExpirationDays")
    public Integer getAssignmentExpirationDays() {
        return this.assignmentExpirationDays;
    }

    public void setAssignmentExpirationDays(Integer assignmentExpirationDays) {
        this.assignmentExpirationDays = assignmentExpirationDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JourneySegmentRequest journeySegmentRequest = (JourneySegmentRequest)o;
        return Objects.equals(this.isActive, journeySegmentRequest.isActive) && Objects.equals(this.displayName, journeySegmentRequest.displayName) && Objects.equals(this.version, journeySegmentRequest.version) && Objects.equals(this.description, journeySegmentRequest.description) && Objects.equals(this.color, journeySegmentRequest.color) && Objects.equals((Object)this.scope, (Object)journeySegmentRequest.scope) && Objects.equals(this.shouldDisplayToAgent, journeySegmentRequest.shouldDisplayToAgent) && Objects.equals(this.context, journeySegmentRequest.context) && Objects.equals(this.journey, journeySegmentRequest.journey) && Objects.equals(this.externalSegment, journeySegmentRequest.externalSegment) && Objects.equals(this.assignmentExpirationDays, journeySegmentRequest.assignmentExpirationDays);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isActive, this.displayName, this.version, this.description, this.color, this.scope, this.shouldDisplayToAgent, this.context, this.journey, this.externalSegment, this.assignmentExpirationDays});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JourneySegmentRequest {\n");
        sb.append("    isActive: ").append(this.toIndentedString(this.isActive)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString((Object)this.scope)).append("\n");
        sb.append("    shouldDisplayToAgent: ").append(this.toIndentedString(this.shouldDisplayToAgent)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    journey: ").append(this.toIndentedString(this.journey)).append("\n");
        sb.append("    externalSegment: ").append(this.toIndentedString(this.externalSegment)).append("\n");
        sb.append("    assignmentExpirationDays: ").append(this.toIndentedString(this.assignmentExpirationDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ScopeEnumDeserializer.class)
    public static enum ScopeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SESSION("Session"),
        CUSTOMER("Customer");

        private String value;

        private ScopeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScopeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ScopeEnum value : ScopeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ScopeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ScopeEnumDeserializer
    extends StdDeserializer<ScopeEnum> {
        public ScopeEnumDeserializer() {
            super(ScopeEnumDeserializer.class);
        }

        public ScopeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ScopeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

