/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContactImportField;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ContactImportSettings
implements Serializable {
    private String id = null;
    private String name = null;
    private List<MatchingCriteriaEnum> matchingCriteria = null;
    private Boolean mergeContacts = null;
    private String externalSourceId = null;
    private List<ContactImportField> importFields = null;
    private Date dateCreated = null;
    private String selfUri = null;

    public ContactImportSettings() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.matchingCriteria = new ArrayList<MatchingCriteriaEnum>();
            this.importFields = new ArrayList<ContactImportField>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ContactImportSettings name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Display name for the settings")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContactImportSettings matchingCriteria(List<MatchingCriteriaEnum> matchingCriteria) {
        this.matchingCriteria = matchingCriteria;
        return this;
    }

    @ApiModelProperty(example="null", value="Which fields you want to identity resolution based on. (e.g.: Email, Phone). It can be empty, populated only one of them or it can be both for now. The order of the items is important for identity resolution")
    @JsonProperty(value="matchingCriteria")
    public List<MatchingCriteriaEnum> getMatchingCriteria() {
        return this.matchingCriteria;
    }

    public void setMatchingCriteria(List<MatchingCriteriaEnum> matchingCriteria) {
        this.matchingCriteria = matchingCriteria;
    }

    public ContactImportSettings mergeContacts(Boolean mergeContacts) {
        this.mergeContacts = mergeContacts;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Decides what happens when a record already found in the system. Action will be Upsert or Merge")
    @JsonProperty(value="mergeContacts")
    public Boolean getMergeContacts() {
        return this.mergeContacts;
    }

    public void setMergeContacts(Boolean mergeContacts) {
        this.mergeContacts = mergeContacts;
    }

    public ContactImportSettings externalSourceId(String externalSourceId) {
        this.externalSourceId = externalSourceId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Define the corresponding source system by the customer, the customer can have different externalId source, they can collect this id from contact service")
    @JsonProperty(value="externalSourceId")
    public String getExternalSourceId() {
        return this.externalSourceId;
    }

    public void setExternalSourceId(String externalSourceId) {
        this.externalSourceId = externalSourceId;
    }

    public ContactImportSettings importFields(List<ContactImportField> importFields) {
        this.importFields = importFields;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Decides which field we need to send towards contact service")
    @JsonProperty(value="importFields")
    public List<ContactImportField> getImportFields() {
        return this.importFields;
    }

    public void setImportFields(List<ContactImportField> importFields) {
        this.importFields = importFields;
    }

    @ApiModelProperty(example="null", value="Creation date for the settings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactImportSettings contactImportSettings = (ContactImportSettings)o;
        return Objects.equals(this.id, contactImportSettings.id) && Objects.equals(this.name, contactImportSettings.name) && Objects.equals(this.matchingCriteria, contactImportSettings.matchingCriteria) && Objects.equals(this.mergeContacts, contactImportSettings.mergeContacts) && Objects.equals(this.externalSourceId, contactImportSettings.externalSourceId) && Objects.equals(this.importFields, contactImportSettings.importFields) && Objects.equals(this.dateCreated, contactImportSettings.dateCreated) && Objects.equals(this.selfUri, contactImportSettings.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.matchingCriteria, this.mergeContacts, this.externalSourceId, this.importFields, this.dateCreated, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactImportSettings {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    matchingCriteria: ").append(this.toIndentedString(this.matchingCriteria)).append("\n");
        sb.append("    mergeContacts: ").append(this.toIndentedString(this.mergeContacts)).append("\n");
        sb.append("    externalSourceId: ").append(this.toIndentedString(this.externalSourceId)).append("\n");
        sb.append("    importFields: ").append(this.toIndentedString(this.importFields)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MatchingCriteriaEnumDeserializer.class)
    public static enum MatchingCriteriaEnum {
        EMAIL("Email"),
        PHONE("Phone");

        private String value;

        private MatchingCriteriaEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MatchingCriteriaEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MatchingCriteriaEnum value : MatchingCriteriaEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MatchingCriteriaEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MatchingCriteriaEnumDeserializer
    extends StdDeserializer<MatchingCriteriaEnum> {
        public MatchingCriteriaEnumDeserializer() {
            super(MatchingCriteriaEnumDeserializer.class);
        }

        public MatchingCriteriaEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MatchingCriteriaEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

