/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SocialMediaQueryFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SocialMediaAsyncAggregationQuery
implements Serializable {
    private String interval = null;
    private String granularity = null;
    private String timeZone = null;
    private List<GroupByEnum> groupBy = new ArrayList<GroupByEnum>();
    private SocialMediaQueryFilter filter = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    private Integer pageSize = null;

    public SocialMediaAsyncAggregationQuery interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public SocialMediaAsyncAggregationQuery granularity(String granularity) {
        this.granularity = granularity;
        return this;
    }

    @ApiModelProperty(example="null", value="Granularity metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H")
    @JsonProperty(value="granularity")
    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public SocialMediaAsyncAggregationQuery timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public SocialMediaAsyncAggregationQuery groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting computations into distinct named subgroups rather than across the entire result set as if it were one group.")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public SocialMediaAsyncAggregationQuery filter(SocialMediaQueryFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", value="Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters")
    @JsonProperty(value="filter")
    public SocialMediaQueryFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SocialMediaQueryFilter filter) {
        this.filter = filter;
    }

    public SocialMediaAsyncAggregationQuery metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Behaves like a SQL SELECT clause. Only named metrics will be retrieved.")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public SocialMediaAsyncAggregationQuery pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of results per page")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SocialMediaAsyncAggregationQuery socialMediaAsyncAggregationQuery = (SocialMediaAsyncAggregationQuery)o;
        return Objects.equals(this.interval, socialMediaAsyncAggregationQuery.interval) && Objects.equals(this.granularity, socialMediaAsyncAggregationQuery.granularity) && Objects.equals(this.timeZone, socialMediaAsyncAggregationQuery.timeZone) && Objects.equals(this.groupBy, socialMediaAsyncAggregationQuery.groupBy) && Objects.equals(this.filter, socialMediaAsyncAggregationQuery.filter) && Objects.equals(this.metrics, socialMediaAsyncAggregationQuery.metrics) && Objects.equals(this.pageSize, socialMediaAsyncAggregationQuery.pageSize);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.granularity, this.timeZone, this.groupBy, this.filter, this.metrics, this.pageSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SocialMediaAsyncAggregationQuery {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    granularity: ").append(this.toIndentedString(this.granularity)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        NSOCIALPOSTS("nSocialPosts"),
        OSOCIALAUTHORS("oSocialAuthors"),
        OSOCIALSENTIMENT("oSocialSentiment"),
        OSOCIALENGAGEMENT("oSocialEngagement");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=GroupByEnumDeserializer.class)
    public static enum GroupByEnum {
        COUNTRY("country"),
        LANGUAGE("language"),
        PLATFORM("platform"),
        TOPIC("topic"),
        ESCALATIONSTATUS("escalationStatus"),
        MESSAGECONTENTTYPE("messageContentType"),
        SENTIMENT("sentiment"),
        DATAINGESTIONRULE("dataIngestionRule"),
        TEXT("text");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByEnumDeserializer
    extends StdDeserializer<GroupByEnum> {
        public GroupByEnumDeserializer() {
            super(GroupByEnumDeserializer.class);
        }

        public GroupByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

