/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.Entity;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class SuggestionContext
implements Serializable {
    private AddressableEntityRef queue = null;
    private MediaTypeEnum mediaType = null;
    private UserReference user = null;
    private AddressableEntityRef externalContact = null;
    private Entity utterance = null;
    private AddressableEntityRef message = null;
    private String queryStatement = null;

    @ApiModelProperty(example="null", value="The queue used to assign the interaction to the user, if any.")
    @JsonProperty(value="queue")
    public AddressableEntityRef getQueue() {
        return this.queue;
    }

    @ApiModelProperty(example="null", value="The media type of the conversation in which the suggestion event was raised.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    @ApiModelProperty(example="null", value="The agent participant who received the raised suggestion, if any.")
    @JsonProperty(value="user")
    public UserReference getUser() {
        return this.user;
    }

    @ApiModelProperty(example="null", value="The external contact of the end-user participant, if any.")
    @JsonProperty(value="externalContact")
    public AddressableEntityRef getExternalContact() {
        return this.externalContact;
    }

    @ApiModelProperty(example="null", value="The utterance in the voice conversation, after which the suggestion was raised, if any.")
    @JsonProperty(value="utterance")
    public Entity getUtterance() {
        return this.utterance;
    }

    @ApiModelProperty(example="null", value="The message in the digital conversation, after which the suggestion was raised, if any.")
    @JsonProperty(value="message")
    public AddressableEntityRef getMessage() {
        return this.message;
    }

    @ApiModelProperty(example="null", value="The query statement used when generating the suggestion, if any.")
    @JsonProperty(value="queryStatement")
    public String getQueryStatement() {
        return this.queryStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestionContext suggestionContext = (SuggestionContext)o;
        return Objects.equals(this.queue, suggestionContext.queue) && Objects.equals((Object)this.mediaType, (Object)suggestionContext.mediaType) && Objects.equals(this.user, suggestionContext.user) && Objects.equals(this.externalContact, suggestionContext.externalContact) && Objects.equals(this.utterance, suggestionContext.utterance) && Objects.equals(this.message, suggestionContext.message) && Objects.equals(this.queryStatement, suggestionContext.queryStatement);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.queue, this.mediaType, this.user, this.externalContact, this.utterance, this.message, this.queryStatement});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SuggestionContext {\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    utterance: ").append(this.toIndentedString(this.utterance)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    queryStatement: ").append(this.toIndentedString(this.queryStatement)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MESSAGE("Message"),
        VOICE("Voice"),
        UNKNOWN("Unknown");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

