/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContentAttachment;
import com.mypurecloud.sdk.v2.model.ContentButtonResponse;
import com.mypurecloud.sdk.v2.model.ContentCard;
import com.mypurecloud.sdk.v2.model.ContentCarousel;
import com.mypurecloud.sdk.v2.model.ContentDatePicker;
import com.mypurecloud.sdk.v2.model.ContentGeneric;
import com.mypurecloud.sdk.v2.model.ContentList;
import com.mypurecloud.sdk.v2.model.ContentNotificationTemplate;
import com.mypurecloud.sdk.v2.model.ContentPostback;
import com.mypurecloud.sdk.v2.model.ContentQuickReply;
import com.mypurecloud.sdk.v2.model.ContentQuickReplyV2;
import com.mypurecloud.sdk.v2.model.ContentReaction;
import com.mypurecloud.sdk.v2.model.ContentStory;
import com.mypurecloud.sdk.v2.model.ContentText;
import com.mypurecloud.sdk.v2.model.MessagingRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Message content element. If contentType = \"Attachment\" only one item is allowed.")
public class MessageContent
implements Serializable {
    private ContentTypeEnum contentType = null;
    private ContentAttachment attachment = null;
    private ContentQuickReply quickReply = null;
    private ContentButtonResponse buttonResponse = null;
    private ContentGeneric generic = null;
    private ContentList list = null;
    private ContentNotificationTemplate template = null;
    private List<ContentReaction> reactions = new ArrayList<ContentReaction>();
    private MessagingRecipient mention = null;
    private ContentPostback postback = null;
    private ContentStory story = null;
    private ContentCard card = null;
    private ContentCarousel carousel = null;
    private ContentText text = null;
    private ContentQuickReplyV2 quickReplyV2 = null;
    private ContentDatePicker datePicker = null;

    public MessageContent contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Type of this content element.")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public MessageContent attachment(ContentAttachment attachment) {
        this.attachment = attachment;
        return this;
    }

    @ApiModelProperty(example="null", value="Attachment content.")
    @JsonProperty(value="attachment")
    public ContentAttachment getAttachment() {
        return this.attachment;
    }

    public void setAttachment(ContentAttachment attachment) {
        this.attachment = attachment;
    }

    public MessageContent quickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply content.")
    @JsonProperty(value="quickReply")
    public ContentQuickReply getQuickReply() {
        return this.quickReply;
    }

    public void setQuickReply(ContentQuickReply quickReply) {
        this.quickReply = quickReply;
    }

    public MessageContent buttonResponse(ContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button response content.")
    @JsonProperty(value="buttonResponse")
    public ContentButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(ContentButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public MessageContent generic(ContentGeneric generic) {
        this.generic = generic;
        return this;
    }

    @ApiModelProperty(example="null", value="Generic content (Deprecated).")
    @JsonProperty(value="generic")
    public ContentGeneric getGeneric() {
        return this.generic;
    }

    public void setGeneric(ContentGeneric generic) {
        this.generic = generic;
    }

    public MessageContent list(ContentList list) {
        this.list = list;
        return this;
    }

    @ApiModelProperty(example="null", value="List content (Deprecated).")
    @JsonProperty(value="list")
    public ContentList getList() {
        return this.list;
    }

    public void setList(ContentList list) {
        this.list = list;
    }

    public MessageContent template(ContentNotificationTemplate template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(example="null", value="Template notification content.")
    @JsonProperty(value="template")
    public ContentNotificationTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ContentNotificationTemplate template) {
        this.template = template;
    }

    public MessageContent reactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of reactions to a message.")
    @JsonProperty(value="reactions")
    public List<ContentReaction> getReactions() {
        return this.reactions;
    }

    public void setReactions(List<ContentReaction> reactions) {
        this.reactions = reactions;
    }

    public MessageContent mention(MessagingRecipient mention) {
        this.mention = mention;
        return this;
    }

    @ApiModelProperty(example="null", value="Mention content.")
    @JsonProperty(value="mention")
    public MessagingRecipient getMention() {
        return this.mention;
    }

    public void setMention(MessagingRecipient mention) {
        this.mention = mention;
    }

    public MessageContent postback(ContentPostback postback) {
        this.postback = postback;
        return this;
    }

    @ApiModelProperty(example="null", value="Structured message postback (Deprecated).")
    @JsonProperty(value="postback")
    public ContentPostback getPostback() {
        return this.postback;
    }

    public void setPostback(ContentPostback postback) {
        this.postback = postback;
    }

    public MessageContent story(ContentStory story) {
        this.story = story;
        return this;
    }

    @ApiModelProperty(example="null", value="Ephemeral story content.")
    @JsonProperty(value="story")
    public ContentStory getStory() {
        return this.story;
    }

    public void setStory(ContentStory story) {
        this.story = story;
    }

    public MessageContent card(ContentCard card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(example="null", value="Card content")
    @JsonProperty(value="card")
    public ContentCard getCard() {
        return this.card;
    }

    public void setCard(ContentCard card) {
        this.card = card;
    }

    public MessageContent carousel(ContentCarousel carousel) {
        this.carousel = carousel;
        return this;
    }

    @ApiModelProperty(example="null", value="Carousel content")
    @JsonProperty(value="carousel")
    public ContentCarousel getCarousel() {
        return this.carousel;
    }

    public void setCarousel(ContentCarousel carousel) {
        this.carousel = carousel;
    }

    public MessageContent text(ContentText text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Text content.")
    @JsonProperty(value="text")
    public ContentText getText() {
        return this.text;
    }

    public void setText(ContentText text) {
        this.text = text;
    }

    public MessageContent quickReplyV2(ContentQuickReplyV2 quickReplyV2) {
        this.quickReplyV2 = quickReplyV2;
        return this;
    }

    @ApiModelProperty(example="null", value="Quick reply V2 content.")
    @JsonProperty(value="quickReplyV2")
    public ContentQuickReplyV2 getQuickReplyV2() {
        return this.quickReplyV2;
    }

    public void setQuickReplyV2(ContentQuickReplyV2 quickReplyV2) {
        this.quickReplyV2 = quickReplyV2;
    }

    public MessageContent datePicker(ContentDatePicker datePicker) {
        this.datePicker = datePicker;
        return this;
    }

    @ApiModelProperty(example="null", value="DatePicker content.")
    @JsonProperty(value="datePicker")
    public ContentDatePicker getDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(ContentDatePicker datePicker) {
        this.datePicker = datePicker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageContent messageContent = (MessageContent)o;
        return Objects.equals((Object)this.contentType, (Object)messageContent.contentType) && Objects.equals(this.attachment, messageContent.attachment) && Objects.equals(this.quickReply, messageContent.quickReply) && Objects.equals(this.buttonResponse, messageContent.buttonResponse) && Objects.equals(this.generic, messageContent.generic) && Objects.equals(this.list, messageContent.list) && Objects.equals(this.template, messageContent.template) && Objects.equals(this.reactions, messageContent.reactions) && Objects.equals(this.mention, messageContent.mention) && Objects.equals(this.postback, messageContent.postback) && Objects.equals(this.story, messageContent.story) && Objects.equals(this.card, messageContent.card) && Objects.equals(this.carousel, messageContent.carousel) && Objects.equals(this.text, messageContent.text) && Objects.equals(this.quickReplyV2, messageContent.quickReplyV2) && Objects.equals(this.datePicker, messageContent.datePicker);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentType, this.attachment, this.quickReply, this.buttonResponse, this.generic, this.list, this.template, this.reactions, this.mention, this.postback, this.story, this.card, this.carousel, this.text, this.quickReplyV2, this.datePicker});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageContent {\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    attachment: ").append(this.toIndentedString(this.attachment)).append("\n");
        sb.append("    quickReply: ").append(this.toIndentedString(this.quickReply)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    generic: ").append(this.toIndentedString(this.generic)).append("\n");
        sb.append("    list: ").append(this.toIndentedString(this.list)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    reactions: ").append(this.toIndentedString(this.reactions)).append("\n");
        sb.append("    mention: ").append(this.toIndentedString(this.mention)).append("\n");
        sb.append("    postback: ").append(this.toIndentedString(this.postback)).append("\n");
        sb.append("    story: ").append(this.toIndentedString(this.story)).append("\n");
        sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        sb.append("    carousel: ").append(this.toIndentedString(this.carousel)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    quickReplyV2: ").append(this.toIndentedString(this.quickReplyV2)).append("\n");
        sb.append("    datePicker: ").append(this.toIndentedString(this.datePicker)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ATTACHMENT("Attachment"),
        QUICKREPLY("QuickReply"),
        NOTIFICATION("Notification"),
        GENERICTEMPLATE("GenericTemplate"),
        LISTTEMPLATE("ListTemplate"),
        POSTBACK("Postback"),
        REACTIONS("Reactions"),
        MENTION("Mention"),
        BUTTONRESPONSE("ButtonResponse"),
        STORY("Story"),
        CARD("Card"),
        CAROUSEL("Carousel"),
        TEXT("Text"),
        QUICKREPLYV2("QuickReplyV2"),
        DATEPICKER("DatePicker");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

