/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Metadata for a CX infrastructure as code accelerator")
public class AcceleratorMetadata
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private OriginEnum origin = null;
    private TypeEnum type = null;
    private String classification = null;
    private List<String> tags = new ArrayList<String>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="name of this accelerator")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="a description of the general purpose of this accelerator")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @ApiModelProperty(example="null", value="where the accelerator originated")
    @JsonProperty(value="origin")
    public OriginEnum getOrigin() {
        return this.origin;
    }

    @ApiModelProperty(example="null", value="type of the artifact")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    @ApiModelProperty(example="null", value="architectural classification into which the accelerator belongs")
    @JsonProperty(value="classification")
    public String getClassification() {
        return this.classification;
    }

    @ApiModelProperty(example="null", value="tags")
    @JsonProperty(value="tags")
    public List<String> getTags() {
        return this.tags;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceleratorMetadata acceleratorMetadata = (AcceleratorMetadata)o;
        return Objects.equals(this.id, acceleratorMetadata.id) && Objects.equals(this.name, acceleratorMetadata.name) && Objects.equals(this.description, acceleratorMetadata.description) && Objects.equals((Object)this.origin, (Object)acceleratorMetadata.origin) && Objects.equals((Object)this.type, (Object)acceleratorMetadata.type) && Objects.equals(this.classification, acceleratorMetadata.classification) && Objects.equals(this.tags, acceleratorMetadata.tags) && Objects.equals(this.selfUri, acceleratorMetadata.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.origin, this.type, this.classification, this.tags, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceleratorMetadata {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString((Object)this.origin)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OriginEnumDeserializer.class)
    public static enum OriginEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COMMUNITY("Community"),
        PARTNER("Partner"),
        GENESYS("Genesys");

        private String value;

        private OriginEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OriginEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OriginEnum value : OriginEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OriginEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MODULE("Module"),
        ACCELERATOR("Accelerator"),
        BLUEPRINT("Blueprint");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class OriginEnumDeserializer
    extends StdDeserializer<OriginEnum> {
        public OriginEnumDeserializer() {
            super(OriginEnumDeserializer.class);
        }

        public OriginEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OriginEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

