/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteDataprivacyMaskingruleRequest;
import com.mypurecloud.sdk.v2.api.request.GetDataprivacyMaskingruleRequest;
import com.mypurecloud.sdk.v2.api.request.GetDataprivacyMaskingrulesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchDataprivacyMaskingruleRequest;
import com.mypurecloud.sdk.v2.api.request.PostDataprivacyMaskingrulesRequest;
import com.mypurecloud.sdk.v2.api.request.PostDataprivacyMaskingrulesValidateRequest;
import com.mypurecloud.sdk.v2.model.MaskingRule;
import com.mypurecloud.sdk.v2.model.MaskingRuleListing;
import com.mypurecloud.sdk.v2.model.MaskingRuleValidateRequest;
import com.mypurecloud.sdk.v2.model.MaskingRuleValidateResponse;
import java.io.IOException;

public class DataPrivacyApi {
    private final ApiClient pcapiClient;

    public DataPrivacyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataPrivacyApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteDataprivacyMaskingrule(String ruleId) throws IOException, ApiException {
        this.deleteDataprivacyMaskingrule(this.createDeleteDataprivacyMaskingruleRequest(ruleId));
    }

    public ApiResponse<Void> deleteDataprivacyMaskingruleWithHttpInfo(String ruleId) throws IOException {
        return this.deleteDataprivacyMaskingrule(this.createDeleteDataprivacyMaskingruleRequest(ruleId).withHttpInfo());
    }

    private DeleteDataprivacyMaskingruleRequest createDeleteDataprivacyMaskingruleRequest(String ruleId) {
        return DeleteDataprivacyMaskingruleRequest.builder().withRuleId(ruleId).build();
    }

    public void deleteDataprivacyMaskingrule(DeleteDataprivacyMaskingruleRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteDataprivacyMaskingrule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MaskingRule getDataprivacyMaskingrule(String ruleId) throws IOException, ApiException {
        return this.getDataprivacyMaskingrule(this.createGetDataprivacyMaskingruleRequest(ruleId));
    }

    public ApiResponse<MaskingRule> getDataprivacyMaskingruleWithHttpInfo(String ruleId) throws IOException {
        return this.getDataprivacyMaskingrule(this.createGetDataprivacyMaskingruleRequest(ruleId).withHttpInfo());
    }

    private GetDataprivacyMaskingruleRequest createGetDataprivacyMaskingruleRequest(String ruleId) {
        return GetDataprivacyMaskingruleRequest.builder().withRuleId(ruleId).build();
    }

    public MaskingRule getDataprivacyMaskingrule(GetDataprivacyMaskingruleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MaskingRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MaskingRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MaskingRule> getDataprivacyMaskingrule(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MaskingRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MaskingRuleListing getDataprivacyMaskingrules() throws IOException, ApiException {
        return this.getDataprivacyMaskingrules(this.createGetDataprivacyMaskingrulesRequest());
    }

    public ApiResponse<MaskingRuleListing> getDataprivacyMaskingrulesWithHttpInfo() throws IOException {
        return this.getDataprivacyMaskingrules(this.createGetDataprivacyMaskingrulesRequest().withHttpInfo());
    }

    private GetDataprivacyMaskingrulesRequest createGetDataprivacyMaskingrulesRequest() {
        return GetDataprivacyMaskingrulesRequest.builder().build();
    }

    public MaskingRuleListing getDataprivacyMaskingrules(GetDataprivacyMaskingrulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MaskingRuleListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MaskingRuleListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MaskingRuleListing> getDataprivacyMaskingrules(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MaskingRuleListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MaskingRule patchDataprivacyMaskingrule(String ruleId, MaskingRule body) throws IOException, ApiException {
        return this.patchDataprivacyMaskingrule(this.createPatchDataprivacyMaskingruleRequest(ruleId, body));
    }

    public ApiResponse<MaskingRule> patchDataprivacyMaskingruleWithHttpInfo(String ruleId, MaskingRule body) throws IOException {
        return this.patchDataprivacyMaskingrule(this.createPatchDataprivacyMaskingruleRequest(ruleId, body).withHttpInfo());
    }

    private PatchDataprivacyMaskingruleRequest createPatchDataprivacyMaskingruleRequest(String ruleId, MaskingRule body) {
        return PatchDataprivacyMaskingruleRequest.builder().withRuleId(ruleId).withBody(body).build();
    }

    public MaskingRule patchDataprivacyMaskingrule(PatchDataprivacyMaskingruleRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MaskingRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MaskingRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MaskingRule> patchDataprivacyMaskingrule(ApiRequest<MaskingRule> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MaskingRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MaskingRule postDataprivacyMaskingrules(MaskingRule body) throws IOException, ApiException {
        return this.postDataprivacyMaskingrules(this.createPostDataprivacyMaskingrulesRequest(body));
    }

    public ApiResponse<MaskingRule> postDataprivacyMaskingrulesWithHttpInfo(MaskingRule body) throws IOException {
        return this.postDataprivacyMaskingrules(this.createPostDataprivacyMaskingrulesRequest(body).withHttpInfo());
    }

    private PostDataprivacyMaskingrulesRequest createPostDataprivacyMaskingrulesRequest(MaskingRule body) {
        return PostDataprivacyMaskingrulesRequest.builder().withBody(body).build();
    }

    public MaskingRule postDataprivacyMaskingrules(PostDataprivacyMaskingrulesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MaskingRule> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MaskingRule>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MaskingRule> postDataprivacyMaskingrules(ApiRequest<MaskingRule> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MaskingRule>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MaskingRuleValidateResponse postDataprivacyMaskingrulesValidate(MaskingRuleValidateRequest body) throws IOException, ApiException {
        return this.postDataprivacyMaskingrulesValidate(this.createPostDataprivacyMaskingrulesValidateRequest(body));
    }

    public ApiResponse<MaskingRuleValidateResponse> postDataprivacyMaskingrulesValidateWithHttpInfo(MaskingRuleValidateRequest body) throws IOException {
        return this.postDataprivacyMaskingrulesValidate(this.createPostDataprivacyMaskingrulesValidateRequest(body).withHttpInfo());
    }

    private PostDataprivacyMaskingrulesValidateRequest createPostDataprivacyMaskingrulesValidateRequest(MaskingRuleValidateRequest body) {
        return PostDataprivacyMaskingrulesValidateRequest.builder().withBody(body).build();
    }

    public MaskingRuleValidateResponse postDataprivacyMaskingrulesValidate(PostDataprivacyMaskingrulesValidateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MaskingRuleValidateResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MaskingRuleValidateResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MaskingRuleValidateResponse> postDataprivacyMaskingrulesValidate(ApiRequest<MaskingRuleValidateRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MaskingRuleValidateResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

