/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ActivityPlanJobException;
import com.mypurecloud.sdk.v2.model.ActivityPlanOccurrenceReference;
import com.mypurecloud.sdk.v2.model.ActivityPlanReference;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ActivityPlanJobResponse
implements Serializable {
    private String id = null;
    private ActivityPlanReference activityPlan = null;
    private StatusEnum status = null;
    private List<ActivityPlanJobException> exceptions = new ArrayList<ActivityPlanJobException>();
    private ErrorBody error = null;
    private ActivityPlanOccurrenceReference occurrence = null;
    private TypeEnum type = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActivityPlanJobResponse activityPlan(ActivityPlanReference activityPlan) {
        this.activityPlan = activityPlan;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity plan associated with this job")
    @JsonProperty(value="activityPlan")
    public ActivityPlanReference getActivityPlan() {
        return this.activityPlan;
    }

    public void setActivityPlan(ActivityPlanReference activityPlan) {
        this.activityPlan = activityPlan;
    }

    public ActivityPlanJobResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ActivityPlanJobResponse exceptions(List<ActivityPlanJobException> exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The list of exceptions that occurred while running this activity plan job. These are exceptions that affect individual occurrences but didn't prevent the job from completing")
    @JsonProperty(value="exceptions")
    public List<ActivityPlanJobException> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ActivityPlanJobException> exceptions) {
        this.exceptions = exceptions;
    }

    public ActivityPlanJobResponse error(ErrorBody error) {
        this.error = error;
        return this;
    }

    @ApiModelProperty(example="null", value="Error details if status == 'Error'. These are errors that caused the job to fail to complete")
    @JsonProperty(value="error")
    public ErrorBody getError() {
        return this.error;
    }

    public void setError(ErrorBody error) {
        this.error = error;
    }

    public ActivityPlanJobResponse occurrence(ActivityPlanOccurrenceReference occurrence) {
        this.occurrence = occurrence;
        return this;
    }

    @ApiModelProperty(example="null", value="The occurrence associated with this job if type == 'DeleteOccurrence'")
    @JsonProperty(value="occurrence")
    public ActivityPlanOccurrenceReference getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(ActivityPlanOccurrenceReference occurrence) {
        this.occurrence = occurrence;
    }

    public ActivityPlanJobResponse type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the job")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityPlanJobResponse activityPlanJobResponse = (ActivityPlanJobResponse)o;
        return Objects.equals(this.id, activityPlanJobResponse.id) && Objects.equals(this.activityPlan, activityPlanJobResponse.activityPlan) && Objects.equals((Object)this.status, (Object)activityPlanJobResponse.status) && Objects.equals(this.exceptions, activityPlanJobResponse.exceptions) && Objects.equals(this.error, activityPlanJobResponse.error) && Objects.equals(this.occurrence, activityPlanJobResponse.occurrence) && Objects.equals((Object)this.type, (Object)activityPlanJobResponse.type) && Objects.equals(this.selfUri, activityPlanJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.activityPlan, this.status, this.exceptions, this.error, this.occurrence, this.type, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityPlanJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    activityPlan: ").append(this.toIndentedString(this.activityPlan)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    exceptions: ").append(this.toIndentedString(this.exceptions)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    occurrence: ").append(this.toIndentedString(this.occurrence)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PROCESSING("Processing"),
        COMPLETE("Complete"),
        ERROR("Error");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RUNPLAN("RunPlan"),
        DELETEOCCURRENCE("DeleteOccurrence");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

