/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.PatchOutcome;
import java.util.HashMap;
import java.util.Map;

public class PatchJourneyOutcomeRequest {
    private String outcomeId;
    private PatchOutcome body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getOutcomeId() {
        return this.outcomeId;
    }

    public void setOutcomeId(String outcomeId) {
        this.outcomeId = outcomeId;
    }

    public PatchJourneyOutcomeRequest withOutcomeId(String outcomeId) {
        this.setOutcomeId(outcomeId);
        return this;
    }

    public PatchOutcome getBody() {
        return this.body;
    }

    public void setBody(PatchOutcome body) {
        this.body = body;
    }

    public PatchJourneyOutcomeRequest withBody(PatchOutcome body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchJourneyOutcomeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<PatchOutcome> withHttpInfo() {
        if (this.outcomeId == null) {
            throw new IllegalStateException("Missing the required parameter 'outcomeId' when building request for PatchJourneyOutcomeRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/journey/outcomes/{outcomeId}").withPathParameter("outcomeId", this.outcomeId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String outcomeId) {
        return new Builder().withRequiredParams(outcomeId);
    }

    public static class Builder {
        private final PatchJourneyOutcomeRequest request = new PatchJourneyOutcomeRequest();

        private Builder() {
        }

        public Builder withOutcomeId(String outcomeId) {
            this.request.setOutcomeId(outcomeId);
            return this;
        }

        public Builder withBody(PatchOutcome body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String outcomeId) {
            this.request.setOutcomeId(outcomeId);
            return this;
        }

        public PatchJourneyOutcomeRequest build() {
            if (this.request.outcomeId == null) {
                throw new IllegalStateException("Missing the required parameter 'outcomeId' when building request for PatchJourneyOutcomeRequest.");
            }
            return this.request;
        }
    }
}

