/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetUsersMeRequest {
    private List<String> expand;
    private String integrationPresenceSource;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public List<String> getExpand() {
        return this.expand;
    }

    public void setExpand(List<String> expand) {
        this.expand = expand;
    }

    public GetUsersMeRequest withExpand(List<String> expand) {
        this.setExpand(expand);
        return this;
    }

    public String getIntegrationPresenceSource() {
        return this.integrationPresenceSource;
    }

    public void setIntegrationPresenceSource(String integrationPresenceSource) {
        this.integrationPresenceSource = integrationPresenceSource;
    }

    public GetUsersMeRequest withIntegrationPresenceSource(String integrationPresenceSource) {
        this.setIntegrationPresenceSource(integrationPresenceSource);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUsersMeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/users/me").withQueryParameters("expand", "multi", this.expand).withQueryParameters("integrationPresenceSource", "", this.integrationPresenceSource).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetUsersMeRequest request = new GetUsersMeRequest();

        private Builder() {
        }

        public Builder withExpand(List<String> expand) {
            this.request.setExpand(expand);
            return this;
        }

        public Builder withExpandEnumValues(List<expandValues> expand) {
            ArrayList<String> stringList = new ArrayList<String>();
            for (expandValues e : expand) {
                stringList.add(e.toString());
            }
            this.request.setExpand(stringList);
            return this;
        }

        public Builder withIntegrationPresenceSource(String integrationPresenceSource) {
            this.request.setIntegrationPresenceSource(integrationPresenceSource);
            return this;
        }

        public Builder withIntegrationPresenceSource(integrationPresenceSourceValues integrationPresenceSource) {
            this.request.setIntegrationPresenceSource(integrationPresenceSource.toString());
            return this;
        }

        public GetUsersMeRequest build() {
            return this.request;
        }
    }

    public static enum integrationPresenceSourceValues {
        MICROSOFTTEAMS("MicrosoftTeams"),
        ZOOMPHONE("ZoomPhone"),
        EIGHTBYEIGHT("EightByEight");

        private String value;

        private integrationPresenceSourceValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static integrationPresenceSourceValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (integrationPresenceSourceValues value : integrationPresenceSourceValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return integrationPresenceSourceValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum expandValues {
        ROUTINGSTATUS("routingStatus"),
        PRESENCE("presence"),
        INTEGRATIONPRESENCE("integrationPresence"),
        CONVERSATIONSUMMARY("conversationSummary"),
        OUTOFOFFICE("outOfOffice"),
        GEOLOCATION("geolocation"),
        STATION("station"),
        AUTHORIZATION("authorization"),
        LASTTOKENISSUED("lasttokenissued"),
        AUTHORIZATION_UNUSEDROLES("authorization.unusedRoles"),
        TEAM("team"),
        WORKPLANBIDRANKS("workPlanBidRanks"),
        EXTERNALCONTACTSSETTINGS("externalContactsSettings"),
        PROFILESKILLS("profileSkills"),
        CERTIFICATIONS("certifications"),
        LOCATIONS("locations"),
        GROUPS("groups"),
        SKILLS("skills"),
        LANGUAGES("languages"),
        LANGUAGEPREFERENCE("languagePreference"),
        EMPLOYERINFO("employerInfo"),
        BIOGRAPHY("biography"),
        DATELASTLOGIN("dateLastLogin"),
        DATE("date"),
        GEOLOCATIONSETTINGS("geolocationsettings"),
        ORGANIZATION("organization"),
        PRESENCEDEFINITIONS("presencedefinitions"),
        DIVISIONEDPRESENCEDEFINITIONS("divisionedpresencedefinitions"),
        LOCATIONDEFINITIONS("locationdefinitions"),
        ORGAUTHORIZATION("orgauthorization"),
        ORGPRODUCTS("orgproducts"),
        FAVORITES("favorites"),
        SUPERIORS("superiors"),
        DIRECTREPORTS("directreports"),
        ADJACENTS("adjacents"),
        ROUTINGSKILLS("routingskills"),
        ROUTINGLANGUAGES("routinglanguages"),
        FIELDCONFIGS("fieldconfigs"),
        TOKEN("token"),
        TRUSTORS("trustors"),
        LOGCAPTURE("logCapture"),
        AUTOANSWERSETTINGS("autoanswersettings");

        private String value;

        private expandValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static expandValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (expandValues value : expandValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return expandValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

