/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetIntegrationsCredentialRequest {
    private String credentialId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public GetIntegrationsCredentialRequest withCredentialId(String credentialId) {
        this.setCredentialId(credentialId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetIntegrationsCredentialRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.credentialId == null) {
            throw new IllegalStateException("Missing the required parameter 'credentialId' when building request for GetIntegrationsCredentialRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/integrations/credentials/{credentialId}").withPathParameter("credentialId", this.credentialId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String credentialId) {
        return new Builder().withRequiredParams(credentialId);
    }

    public static class Builder {
        private final GetIntegrationsCredentialRequest request = new GetIntegrationsCredentialRequest();

        private Builder() {
        }

        public Builder withCredentialId(String credentialId) {
            this.request.setCredentialId(credentialId);
            return this;
        }

        public Builder withRequiredParams(String credentialId) {
            this.request.setCredentialId(credentialId);
            return this;
        }

        public GetIntegrationsCredentialRequest build() {
            if (this.request.credentialId == null) {
                throw new IllegalStateException("Missing the required parameter 'credentialId' when building request for GetIntegrationsCredentialRequest.");
            }
            return this.request;
        }
    }
}

