/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CreateObjective;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CreateMetric
implements Serializable {
    private String metricDefinitionId = null;
    private String externalMetricDefinitionId = null;
    private CreateObjective objective = null;
    private String performanceProfileId = null;
    private String name = null;
    private Integer precision = null;
    private TimeDisplayUnitEnum timeDisplayUnit = null;

    public CreateMetric metricDefinitionId(String metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of associated metric definition")
    @JsonProperty(value="metricDefinitionId")
    public String getMetricDefinitionId() {
        return this.metricDefinitionId;
    }

    public void setMetricDefinitionId(String metricDefinitionId) {
        this.metricDefinitionId = metricDefinitionId;
    }

    public CreateMetric externalMetricDefinitionId(String externalMetricDefinitionId) {
        this.externalMetricDefinitionId = externalMetricDefinitionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of associated external metric definition")
    @JsonProperty(value="externalMetricDefinitionId")
    public String getExternalMetricDefinitionId() {
        return this.externalMetricDefinitionId;
    }

    public void setExternalMetricDefinitionId(String externalMetricDefinitionId) {
        this.externalMetricDefinitionId = externalMetricDefinitionId;
    }

    public CreateMetric objective(CreateObjective objective) {
        this.objective = objective;
        return this;
    }

    @ApiModelProperty(example="null", value="Associated objective for this metric")
    @JsonProperty(value="objective")
    public CreateObjective getObjective() {
        return this.objective;
    }

    public void setObjective(CreateObjective objective) {
        this.objective = objective;
    }

    public CreateMetric performanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
        return this;
    }

    @ApiModelProperty(example="null", value="Performance profile id of this metric")
    @JsonProperty(value="performanceProfileId")
    public String getPerformanceProfileId() {
        return this.performanceProfileId;
    }

    public void setPerformanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
    }

    public CreateMetric name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of this metric")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateMetric precision(Integer precision) {
        this.precision = precision;
        return this;
    }

    @ApiModelProperty(example="null", value="The precision of the metric, must be between 0 and 5")
    @JsonProperty(value="precision")
    public Integer getPrecision() {
        return this.precision;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public CreateMetric timeDisplayUnit(TimeDisplayUnitEnum timeDisplayUnit) {
        this.timeDisplayUnit = timeDisplayUnit;
        return this;
    }

    @ApiModelProperty(example="null", value="The time unit in which the metric should be displayed -- this parameter is ignored when displaying non-time values")
    @JsonProperty(value="timeDisplayUnit")
    public TimeDisplayUnitEnum getTimeDisplayUnit() {
        return this.timeDisplayUnit;
    }

    public void setTimeDisplayUnit(TimeDisplayUnitEnum timeDisplayUnit) {
        this.timeDisplayUnit = timeDisplayUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateMetric createMetric = (CreateMetric)o;
        return Objects.equals(this.metricDefinitionId, createMetric.metricDefinitionId) && Objects.equals(this.externalMetricDefinitionId, createMetric.externalMetricDefinitionId) && Objects.equals(this.objective, createMetric.objective) && Objects.equals(this.performanceProfileId, createMetric.performanceProfileId) && Objects.equals(this.name, createMetric.name) && Objects.equals(this.precision, createMetric.precision) && Objects.equals((Object)this.timeDisplayUnit, (Object)createMetric.timeDisplayUnit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricDefinitionId, this.externalMetricDefinitionId, this.objective, this.performanceProfileId, this.name, this.precision, this.timeDisplayUnit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateMetric {\n");
        sb.append("    metricDefinitionId: ").append(this.toIndentedString(this.metricDefinitionId)).append("\n");
        sb.append("    externalMetricDefinitionId: ").append(this.toIndentedString(this.externalMetricDefinitionId)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    performanceProfileId: ").append(this.toIndentedString(this.performanceProfileId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    precision: ").append(this.toIndentedString(this.precision)).append("\n");
        sb.append("    timeDisplayUnit: ").append(this.toIndentedString((Object)this.timeDisplayUnit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TimeDisplayUnitEnumDeserializer.class)
    public static enum TimeDisplayUnitEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NONE("None"),
        SECONDS("Seconds"),
        MINUTES("Minutes"),
        HOURS("Hours");

        private String value;

        private TimeDisplayUnitEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TimeDisplayUnitEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TimeDisplayUnitEnum value : TimeDisplayUnitEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TimeDisplayUnitEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TimeDisplayUnitEnumDeserializer
    extends StdDeserializer<TimeDisplayUnitEnum> {
        public TimeDisplayUnitEnumDeserializer() {
            super(TimeDisplayUnitEnumDeserializer.class);
        }

        public TimeDisplayUnitEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TimeDisplayUnitEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

