/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CoachingAnnotation;
import java.util.HashMap;
import java.util.Map;

public class PatchCoachingAppointmentAnnotationRequest {
    private String appointmentId;
    private String annotationId;
    private CoachingAnnotation body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public PatchCoachingAppointmentAnnotationRequest withAppointmentId(String appointmentId) {
        this.setAppointmentId(appointmentId);
        return this;
    }

    public String getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(String annotationId) {
        this.annotationId = annotationId;
    }

    public PatchCoachingAppointmentAnnotationRequest withAnnotationId(String annotationId) {
        this.setAnnotationId(annotationId);
        return this;
    }

    public CoachingAnnotation getBody() {
        return this.body;
    }

    public void setBody(CoachingAnnotation body) {
        this.body = body;
    }

    public PatchCoachingAppointmentAnnotationRequest withBody(CoachingAnnotation body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchCoachingAppointmentAnnotationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CoachingAnnotation> withHttpInfo() {
        if (this.appointmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PatchCoachingAppointmentAnnotationRequest.");
        }
        if (this.annotationId == null) {
            throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for PatchCoachingAppointmentAnnotationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingAppointmentAnnotationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/coaching/appointments/{appointmentId}/annotations/{annotationId}").withPathParameter("appointmentId", this.appointmentId).withPathParameter("annotationId", this.annotationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String appointmentId, String annotationId, CoachingAnnotation body) {
        return new Builder().withRequiredParams(appointmentId, annotationId, body);
    }

    public static class Builder {
        private final PatchCoachingAppointmentAnnotationRequest request = new PatchCoachingAppointmentAnnotationRequest();

        private Builder() {
        }

        public Builder withAppointmentId(String appointmentId) {
            this.request.setAppointmentId(appointmentId);
            return this;
        }

        public Builder withAnnotationId(String annotationId) {
            this.request.setAnnotationId(annotationId);
            return this;
        }

        public Builder withBody(CoachingAnnotation body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String appointmentId, String annotationId, CoachingAnnotation body) {
            this.request.setAppointmentId(appointmentId);
            this.request.setAnnotationId(annotationId);
            this.request.setBody(body);
            return this;
        }

        public PatchCoachingAppointmentAnnotationRequest build() {
            if (this.request.appointmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PatchCoachingAppointmentAnnotationRequest.");
            }
            if (this.request.annotationId == null) {
                throw new IllegalStateException("Missing the required parameter 'annotationId' when building request for PatchCoachingAppointmentAnnotationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingAppointmentAnnotationRequest.");
            }
            return this.request;
        }
    }
}

