/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WfmProcessUploadRequest;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest {
    private String businessUnitId;
    private LocalDate weekId;
    private WfmProcessUploadRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getBusinessUnitId() {
        return this.businessUnitId;
    }

    public void setBusinessUnitId(String businessUnitId) {
        this.businessUnitId = businessUnitId;
    }

    public PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest withBusinessUnitId(String businessUnitId) {
        this.setBusinessUnitId(businessUnitId);
        return this;
    }

    public LocalDate getWeekId() {
        return this.weekId;
    }

    public void setWeekId(LocalDate weekId) {
        this.weekId = weekId;
    }

    public PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest withWeekId(LocalDate weekId) {
        this.setWeekId(weekId);
        return this;
    }

    public WfmProcessUploadRequest getBody() {
        return this.body;
    }

    public void setBody(WfmProcessUploadRequest body) {
        this.body = body;
    }

    public PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest withBody(WfmProcessUploadRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<WfmProcessUploadRequest> withHttpInfo() {
        if (this.businessUnitId == null) {
            throw new IllegalStateException("Missing the required parameter 'businessUnitId' when building request for PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest.");
        }
        if (this.weekId == null) {
            throw new IllegalStateException("Missing the required parameter 'weekId' when building request for PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/workforcemanagement/businessunits/{businessUnitId}/weeks/{weekId}/schedules/import").withPathParameter("businessUnitId", this.businessUnitId).withPathParameter("weekId", this.weekId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String businessUnitId, LocalDate weekId, WfmProcessUploadRequest body) {
        return new Builder().withRequiredParams(businessUnitId, weekId, body);
    }

    public static class Builder {
        private final PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest request = new PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest();

        private Builder() {
        }

        public Builder withBusinessUnitId(String businessUnitId) {
            this.request.setBusinessUnitId(businessUnitId);
            return this;
        }

        public Builder withWeekId(LocalDate weekId) {
            this.request.setWeekId(weekId);
            return this;
        }

        public Builder withBody(WfmProcessUploadRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String businessUnitId, LocalDate weekId, WfmProcessUploadRequest body) {
            this.request.setBusinessUnitId(businessUnitId);
            this.request.setWeekId(weekId);
            this.request.setBody(body);
            return this;
        }

        public PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest build() {
            if (this.request.businessUnitId == null) {
                throw new IllegalStateException("Missing the required parameter 'businessUnitId' when building request for PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest.");
            }
            if (this.request.weekId == null) {
                throw new IllegalStateException("Missing the required parameter 'weekId' when building request for PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostWorkforcemanagementBusinessunitWeekSchedulesImportRequest.");
            }
            return this.request;
        }
    }
}

