/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetJourneyViewVersionChartVersionRequest {
    private String viewId;
    private String journeyViewVersion;
    private String chartId;
    private String chartVersion;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getViewId() {
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public GetJourneyViewVersionChartVersionRequest withViewId(String viewId) {
        this.setViewId(viewId);
        return this;
    }

    public String getJourneyViewVersion() {
        return this.journeyViewVersion;
    }

    public void setJourneyViewVersion(String journeyViewVersion) {
        this.journeyViewVersion = journeyViewVersion;
    }

    public GetJourneyViewVersionChartVersionRequest withJourneyViewVersion(String journeyViewVersion) {
        this.setJourneyViewVersion(journeyViewVersion);
        return this;
    }

    public String getChartId() {
        return this.chartId;
    }

    public void setChartId(String chartId) {
        this.chartId = chartId;
    }

    public GetJourneyViewVersionChartVersionRequest withChartId(String chartId) {
        this.setChartId(chartId);
        return this;
    }

    public String getChartVersion() {
        return this.chartVersion;
    }

    public void setChartVersion(String chartVersion) {
        this.chartVersion = chartVersion;
    }

    public GetJourneyViewVersionChartVersionRequest withChartVersion(String chartVersion) {
        this.setChartVersion(chartVersion);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetJourneyViewVersionChartVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.viewId == null) {
            throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionChartVersionRequest.");
        }
        if (this.journeyViewVersion == null) {
            throw new IllegalStateException("Missing the required parameter 'journeyViewVersion' when building request for GetJourneyViewVersionChartVersionRequest.");
        }
        if (this.chartId == null) {
            throw new IllegalStateException("Missing the required parameter 'chartId' when building request for GetJourneyViewVersionChartVersionRequest.");
        }
        if (this.chartVersion == null) {
            throw new IllegalStateException("Missing the required parameter 'chartVersion' when building request for GetJourneyViewVersionChartVersionRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/journey/views/{viewId}/versions/{journeyViewVersion}/charts/{chartId}/versions/{chartVersion}").withPathParameter("viewId", this.viewId).withPathParameter("journeyViewVersion", this.journeyViewVersion).withPathParameter("chartId", this.chartId).withPathParameter("chartVersion", this.chartVersion).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String viewId, String journeyViewVersion, String chartId, String chartVersion) {
        return new Builder().withRequiredParams(viewId, journeyViewVersion, chartId, chartVersion);
    }

    public static class Builder {
        private final GetJourneyViewVersionChartVersionRequest request = new GetJourneyViewVersionChartVersionRequest();

        private Builder() {
        }

        public Builder withViewId(String viewId) {
            this.request.setViewId(viewId);
            return this;
        }

        public Builder withJourneyViewVersion(String journeyViewVersion) {
            this.request.setJourneyViewVersion(journeyViewVersion);
            return this;
        }

        public Builder withChartId(String chartId) {
            this.request.setChartId(chartId);
            return this;
        }

        public Builder withChartVersion(String chartVersion) {
            this.request.setChartVersion(chartVersion);
            return this;
        }

        public Builder withRequiredParams(String viewId, String journeyViewVersion, String chartId, String chartVersion) {
            this.request.setViewId(viewId);
            this.request.setJourneyViewVersion(journeyViewVersion);
            this.request.setChartId(chartId);
            this.request.setChartVersion(chartVersion);
            return this;
        }

        public GetJourneyViewVersionChartVersionRequest build() {
            if (this.request.viewId == null) {
                throw new IllegalStateException("Missing the required parameter 'viewId' when building request for GetJourneyViewVersionChartVersionRequest.");
            }
            if (this.request.journeyViewVersion == null) {
                throw new IllegalStateException("Missing the required parameter 'journeyViewVersion' when building request for GetJourneyViewVersionChartVersionRequest.");
            }
            if (this.request.chartId == null) {
                throw new IllegalStateException("Missing the required parameter 'chartId' when building request for GetJourneyViewVersionChartVersionRequest.");
            }
            if (this.request.chartVersion == null) {
                throw new IllegalStateException("Missing the required parameter 'chartVersion' when building request for GetJourneyViewVersionChartVersionRequest.");
            }
            return this.request;
        }
    }
}

