/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.NuanceBotVariable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Model for a Nuance bot transfer node")
public class NuanceBotTransferNode
implements Serializable {
    private String id = null;
    private String name = null;
    private TypeEnum type = null;
    private String description = null;
    private List<NuanceBotVariable> requestVariables = new ArrayList<NuanceBotVariable>();

    public NuanceBotTransferNode id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The transfer node ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public NuanceBotTransferNode name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The transfer node name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NuanceBotTransferNode type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The transfer node type")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public NuanceBotTransferNode description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The transfer node description")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public NuanceBotTransferNode requestVariables(List<NuanceBotVariable> requestVariables) {
        this.requestVariables = requestVariables;
        return this;
    }

    @ApiModelProperty(example="null", value="List of variables associated with this transfer node")
    @JsonProperty(value="requestVariables")
    public List<NuanceBotVariable> getRequestVariables() {
        return this.requestVariables;
    }

    public void setRequestVariables(List<NuanceBotVariable> requestVariables) {
        this.requestVariables = requestVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NuanceBotTransferNode nuanceBotTransferNode = (NuanceBotTransferNode)o;
        return Objects.equals(this.id, nuanceBotTransferNode.id) && Objects.equals(this.name, nuanceBotTransferNode.name) && Objects.equals((Object)this.type, (Object)nuanceBotTransferNode.type) && Objects.equals(this.description, nuanceBotTransferNode.description) && Objects.equals(this.requestVariables, nuanceBotTransferNode.requestVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.type, this.description, this.requestVariables});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NuanceBotTransferNode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    requestVariables: ").append(this.toIndentedString(this.requestVariables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        END("End"),
        ESCALATE("Escalate");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

