/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteChatsUserMessagesPinRequest {
    private String userId;
    private String pinnedMessageId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public DeleteChatsUserMessagesPinRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getPinnedMessageId() {
        return this.pinnedMessageId;
    }

    public void setPinnedMessageId(String pinnedMessageId) {
        this.pinnedMessageId = pinnedMessageId;
    }

    public DeleteChatsUserMessagesPinRequest withPinnedMessageId(String pinnedMessageId) {
        this.setPinnedMessageId(pinnedMessageId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteChatsUserMessagesPinRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for DeleteChatsUserMessagesPinRequest.");
        }
        if (this.pinnedMessageId == null) {
            throw new IllegalStateException("Missing the required parameter 'pinnedMessageId' when building request for DeleteChatsUserMessagesPinRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/chats/users/{userId}/messages/pins/{pinnedMessageId}").withPathParameter("userId", this.userId).withPathParameter("pinnedMessageId", this.pinnedMessageId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String pinnedMessageId) {
        return new Builder().withRequiredParams(userId, pinnedMessageId);
    }

    public static class Builder {
        private final DeleteChatsUserMessagesPinRequest request = new DeleteChatsUserMessagesPinRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withPinnedMessageId(String pinnedMessageId) {
            this.request.setPinnedMessageId(pinnedMessageId);
            return this;
        }

        public Builder withRequiredParams(String userId, String pinnedMessageId) {
            this.request.setUserId(userId);
            this.request.setPinnedMessageId(pinnedMessageId);
            return this;
        }

        public DeleteChatsUserMessagesPinRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for DeleteChatsUserMessagesPinRequest.");
            }
            if (this.request.pinnedMessageId == null) {
                throw new IllegalStateException("Missing the required parameter 'pinnedMessageId' when building request for DeleteChatsUserMessagesPinRequest.");
            }
            return this.request;
        }
    }
}

