/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ConversationRecipientAdditionalIdentifier;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information about the recipient the message is received from.")
public class ConversationMessagingFromRecipient
implements Serializable {
    private String nickname = null;
    private String id = null;
    private IdTypeEnum idType = null;
    private String image = null;
    private String firstName = null;
    private String lastName = null;
    private String email = null;
    private String externalContactId = null;
    private List<ConversationRecipientAdditionalIdentifier> additionalIds = new ArrayList<ConversationRecipientAdditionalIdentifier>();

    @ApiModelProperty(example="null", value="Nickname or display name of the recipient.")
    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    public ConversationMessagingFromRecipient id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipient ID specific to the provider.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="The recipient ID type. This is used to indicate the format used for the ID.")
    @JsonProperty(value="idType")
    public IdTypeEnum getIdType() {
        return this.idType;
    }

    public ConversationMessagingFromRecipient image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image that represents the recipient.")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ConversationMessagingFromRecipient firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(example="null", value="First name of the recipient.")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public ConversationMessagingFromRecipient lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(example="null", value="Last name of the recipient.")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @ApiModelProperty(example="null", value="E-mail address of the recipient.")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public ConversationMessagingFromRecipient externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier of the external contact.")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    @ApiModelProperty(example="null", value="List of recipient additional identifiers")
    @JsonProperty(value="additionalIds")
    public List<ConversationRecipientAdditionalIdentifier> getAdditionalIds() {
        return this.additionalIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessagingFromRecipient conversationMessagingFromRecipient = (ConversationMessagingFromRecipient)o;
        return Objects.equals(this.nickname, conversationMessagingFromRecipient.nickname) && Objects.equals(this.id, conversationMessagingFromRecipient.id) && Objects.equals((Object)this.idType, (Object)conversationMessagingFromRecipient.idType) && Objects.equals(this.image, conversationMessagingFromRecipient.image) && Objects.equals(this.firstName, conversationMessagingFromRecipient.firstName) && Objects.equals(this.lastName, conversationMessagingFromRecipient.lastName) && Objects.equals(this.email, conversationMessagingFromRecipient.email) && Objects.equals(this.externalContactId, conversationMessagingFromRecipient.externalContactId) && Objects.equals(this.additionalIds, conversationMessagingFromRecipient.additionalIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nickname, this.id, this.idType, this.image, this.firstName, this.lastName, this.email, this.externalContactId, this.additionalIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessagingFromRecipient {\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    idType: ").append(this.toIndentedString((Object)this.idType)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    additionalIds: ").append(this.toIndentedString(this.additionalIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IdTypeEnumDeserializer.class)
    public static enum IdTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("Email"),
        PHONE("Phone"),
        OPAQUE("Opaque");

        private String value;

        private IdTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IdTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IdTypeEnum value : IdTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IdTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class IdTypeEnumDeserializer
    extends StdDeserializer<IdTypeEnum> {
        public IdTypeEnumDeserializer() {
            super(IdTypeEnumDeserializer.class);
        }

        public IdTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IdTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

