/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ConsultTransferToAgent;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsCallParticipantConsultAgentRequest {
    private String conversationId;
    private String participantId;
    private ConsultTransferToAgent body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationsCallParticipantConsultAgentRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PostConversationsCallParticipantConsultAgentRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public ConsultTransferToAgent getBody() {
        return this.body;
    }

    public void setBody(ConsultTransferToAgent body) {
        this.body = body;
    }

    public PostConversationsCallParticipantConsultAgentRequest withBody(ConsultTransferToAgent body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsCallParticipantConsultAgentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ConsultTransferToAgent> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsCallParticipantConsultAgentRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationsCallParticipantConsultAgentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsCallParticipantConsultAgentRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/calls/{conversationId}/participants/{participantId}/consult/agent").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, ConsultTransferToAgent body) {
        return new Builder().withRequiredParams(conversationId, participantId, body);
    }

    public static class Builder {
        private final PostConversationsCallParticipantConsultAgentRequest request = new PostConversationsCallParticipantConsultAgentRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(ConsultTransferToAgent body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, ConsultTransferToAgent body) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsCallParticipantConsultAgentRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsCallParticipantConsultAgentRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PostConversationsCallParticipantConsultAgentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsCallParticipantConsultAgentRequest.");
            }
            return this.request;
        }
    }
}

