/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Annotation;
import com.mypurecloud.sdk.v2.model.ChatMessage;
import com.mypurecloud.sdk.v2.model.MediaResult;
import com.mypurecloud.sdk.v2.model.RecordingEmailMessage;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Recording
implements Serializable {
    private String id = null;
    private String name = null;
    private String conversationId = null;
    private String path = null;
    private String startTime = null;
    private String endTime = null;
    private String media = null;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private List<ChatMessage> transcript = new ArrayList<ChatMessage>();
    private List<RecordingEmailMessage> emailTranscript = new ArrayList<RecordingEmailMessage>();
    private FileStateEnum fileState = null;
    private Date restoreExpirationTime = null;
    private Map<String, MediaResult> mediaUris = new HashMap<String, MediaResult>();
    private Long estimatedTranscodeTimeMs = null;
    private Long actualTranscodeTimeMs = null;
    private Date archiveDate = null;
    private ArchiveMediumEnum archiveMedium = null;
    private Date deleteDate = null;
    private Integer maxAllowedRestorationsForOrg = null;
    private Integer remainingRestorationsAllowedForOrg = null;
    private String sessionId = null;
    private List<User> users = new ArrayList<User>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Recording name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Recording conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Recording path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Recording startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="startTime")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public Recording endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="endTime")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Recording media(String media) {
        this.media = media;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of media that the recording is. At the moment that could be audio, chat, or email.")
    @JsonProperty(value="media")
    public String getMedia() {
        return this.media;
    }

    public void setMedia(String media) {
        this.media = media;
    }

    public Recording annotations(List<Annotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    @ApiModelProperty(example="null", value="Annotations that belong to the recording.")
    @JsonProperty(value="annotations")
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public Recording transcript(List<ChatMessage> transcript) {
        this.transcript = transcript;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents a chat transcript")
    @JsonProperty(value="transcript")
    public List<ChatMessage> getTranscript() {
        return this.transcript;
    }

    public void setTranscript(List<ChatMessage> transcript) {
        this.transcript = transcript;
    }

    public Recording emailTranscript(List<RecordingEmailMessage> emailTranscript) {
        this.emailTranscript = emailTranscript;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents an email transcript")
    @JsonProperty(value="emailTranscript")
    public List<RecordingEmailMessage> getEmailTranscript() {
        return this.emailTranscript;
    }

    public void setEmailTranscript(List<RecordingEmailMessage> emailTranscript) {
        this.emailTranscript = emailTranscript;
    }

    public Recording fileState(FileStateEnum fileState) {
        this.fileState = fileState;
        return this;
    }

    @ApiModelProperty(example="null", value="Represents the current file state for a recording. Examples: Uploading, Archived, etc")
    @JsonProperty(value="fileState")
    public FileStateEnum getFileState() {
        return this.fileState;
    }

    public void setFileState(FileStateEnum fileState) {
        this.fileState = fileState;
    }

    public Recording restoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The amount of time a restored recording will remain restored before being archived again. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="restoreExpirationTime")
    public Date getRestoreExpirationTime() {
        return this.restoreExpirationTime;
    }

    public void setRestoreExpirationTime(Date restoreExpirationTime) {
        this.restoreExpirationTime = restoreExpirationTime;
    }

    public Recording mediaUris(Map<String, MediaResult> mediaUris) {
        this.mediaUris = mediaUris;
        return this;
    }

    @ApiModelProperty(example="null", value="The different mediaUris for the recording.")
    @JsonProperty(value="mediaUris")
    public Map<String, MediaResult> getMediaUris() {
        return this.mediaUris;
    }

    public void setMediaUris(Map<String, MediaResult> mediaUris) {
        this.mediaUris = mediaUris;
    }

    public Recording estimatedTranscodeTimeMs(Long estimatedTranscodeTimeMs) {
        this.estimatedTranscodeTimeMs = estimatedTranscodeTimeMs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="estimatedTranscodeTimeMs")
    public Long getEstimatedTranscodeTimeMs() {
        return this.estimatedTranscodeTimeMs;
    }

    public void setEstimatedTranscodeTimeMs(Long estimatedTranscodeTimeMs) {
        this.estimatedTranscodeTimeMs = estimatedTranscodeTimeMs;
    }

    public Recording actualTranscodeTimeMs(Long actualTranscodeTimeMs) {
        this.actualTranscodeTimeMs = actualTranscodeTimeMs;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="actualTranscodeTimeMs")
    public Long getActualTranscodeTimeMs() {
        return this.actualTranscodeTimeMs;
    }

    public void setActualTranscodeTimeMs(Long actualTranscodeTimeMs) {
        this.actualTranscodeTimeMs = actualTranscodeTimeMs;
    }

    public Recording archiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be archived. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="archiveDate")
    public Date getArchiveDate() {
        return this.archiveDate;
    }

    public void setArchiveDate(Date archiveDate) {
        this.archiveDate = archiveDate;
    }

    public Recording archiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of archive medium used. Example: CloudArchive")
    @JsonProperty(value="archiveMedium")
    public ArchiveMediumEnum getArchiveMedium() {
        return this.archiveMedium;
    }

    public void setArchiveMedium(ArchiveMediumEnum archiveMedium) {
        this.archiveMedium = archiveMedium;
    }

    public Recording deleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the recording will be deleted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="deleteDate")
    public Date getDeleteDate() {
        return this.deleteDate;
    }

    public void setDeleteDate(Date deleteDate) {
        this.deleteDate = deleteDate;
    }

    public Recording maxAllowedRestorationsForOrg(Integer maxAllowedRestorationsForOrg) {
        this.maxAllowedRestorationsForOrg = maxAllowedRestorationsForOrg;
        return this;
    }

    @ApiModelProperty(example="null", value="How many archive restorations the organization is allowed to have.")
    @JsonProperty(value="maxAllowedRestorationsForOrg")
    public Integer getMaxAllowedRestorationsForOrg() {
        return this.maxAllowedRestorationsForOrg;
    }

    public void setMaxAllowedRestorationsForOrg(Integer maxAllowedRestorationsForOrg) {
        this.maxAllowedRestorationsForOrg = maxAllowedRestorationsForOrg;
    }

    public Recording remainingRestorationsAllowedForOrg(Integer remainingRestorationsAllowedForOrg) {
        this.remainingRestorationsAllowedForOrg = remainingRestorationsAllowedForOrg;
        return this;
    }

    @ApiModelProperty(example="null", value="The remaining archive restorations the organization has.")
    @JsonProperty(value="remainingRestorationsAllowedForOrg")
    public Integer getRemainingRestorationsAllowedForOrg() {
        return this.remainingRestorationsAllowedForOrg;
    }

    public void setRemainingRestorationsAllowedForOrg(Integer remainingRestorationsAllowedForOrg) {
        this.remainingRestorationsAllowedForOrg = remainingRestorationsAllowedForOrg;
    }

    public Recording sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The session id represents an external resource id, such as email, call, chat, etc")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Recording users(List<User> users) {
        this.users = users;
        return this;
    }

    @ApiModelProperty(example="null", value="The users participating in the conversation")
    @JsonProperty(value="users")
    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recording recording = (Recording)o;
        return Objects.equals(this.id, recording.id) && Objects.equals(this.name, recording.name) && Objects.equals(this.conversationId, recording.conversationId) && Objects.equals(this.path, recording.path) && Objects.equals(this.startTime, recording.startTime) && Objects.equals(this.endTime, recording.endTime) && Objects.equals(this.media, recording.media) && Objects.equals(this.annotations, recording.annotations) && Objects.equals(this.transcript, recording.transcript) && Objects.equals(this.emailTranscript, recording.emailTranscript) && Objects.equals((Object)this.fileState, (Object)recording.fileState) && Objects.equals(this.restoreExpirationTime, recording.restoreExpirationTime) && Objects.equals(this.mediaUris, recording.mediaUris) && Objects.equals(this.estimatedTranscodeTimeMs, recording.estimatedTranscodeTimeMs) && Objects.equals(this.actualTranscodeTimeMs, recording.actualTranscodeTimeMs) && Objects.equals(this.archiveDate, recording.archiveDate) && Objects.equals((Object)this.archiveMedium, (Object)recording.archiveMedium) && Objects.equals(this.deleteDate, recording.deleteDate) && Objects.equals(this.maxAllowedRestorationsForOrg, recording.maxAllowedRestorationsForOrg) && Objects.equals(this.remainingRestorationsAllowedForOrg, recording.remainingRestorationsAllowedForOrg) && Objects.equals(this.sessionId, recording.sessionId) && Objects.equals(this.users, recording.users) && Objects.equals(this.selfUri, recording.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.conversationId, this.path, this.startTime, this.endTime, this.media, this.annotations, this.transcript, this.emailTranscript, this.fileState, this.restoreExpirationTime, this.mediaUris, this.estimatedTranscodeTimeMs, this.actualTranscodeTimeMs, this.archiveDate, this.archiveMedium, this.deleteDate, this.maxAllowedRestorationsForOrg, this.remainingRestorationsAllowedForOrg, this.sessionId, this.users, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recording {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    annotations: ").append(this.toIndentedString(this.annotations)).append("\n");
        sb.append("    transcript: ").append(this.toIndentedString(this.transcript)).append("\n");
        sb.append("    emailTranscript: ").append(this.toIndentedString(this.emailTranscript)).append("\n");
        sb.append("    fileState: ").append(this.toIndentedString((Object)this.fileState)).append("\n");
        sb.append("    restoreExpirationTime: ").append(this.toIndentedString(this.restoreExpirationTime)).append("\n");
        sb.append("    mediaUris: ").append(this.toIndentedString(this.mediaUris)).append("\n");
        sb.append("    estimatedTranscodeTimeMs: ").append(this.toIndentedString(this.estimatedTranscodeTimeMs)).append("\n");
        sb.append("    actualTranscodeTimeMs: ").append(this.toIndentedString(this.actualTranscodeTimeMs)).append("\n");
        sb.append("    archiveDate: ").append(this.toIndentedString(this.archiveDate)).append("\n");
        sb.append("    archiveMedium: ").append(this.toIndentedString((Object)this.archiveMedium)).append("\n");
        sb.append("    deleteDate: ").append(this.toIndentedString(this.deleteDate)).append("\n");
        sb.append("    maxAllowedRestorationsForOrg: ").append(this.toIndentedString(this.maxAllowedRestorationsForOrg)).append("\n");
        sb.append("    remainingRestorationsAllowedForOrg: ").append(this.toIndentedString(this.remainingRestorationsAllowedForOrg)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ArchiveMediumEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLOUDARCHIVE("CLOUDARCHIVE");

        private String value;

        private ArchiveMediumEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ArchiveMediumEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ArchiveMediumEnum value : ArchiveMediumEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ArchiveMediumEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum FileStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ARCHIVED("ARCHIVED"),
        AVAILABLE("AVAILABLE"),
        DELETED("DELETED"),
        RESTORED("RESTORED"),
        RESTORING("RESTORING"),
        UPLOADING("UPLOADING"),
        ERROR("ERROR");

        private String value;

        private FileStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileStateEnum value : FileStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

